/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudHelper;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.springframework.data.domain.Page;

final class CrudExecutor {
    private static final int SEARCH_BY_ID_LIMIT = 2;
    private static final ObjectMapper mapper = new ObjectMapper();

    private CrudExecutor() {
    }

    public static <T> T execute(final EntityInfo entityInfo, CrudAction crudAction, final CrudRequest crudRequest) {
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        return switch (crudAction) {
            case CrudAction.UNIQUE -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.single(session, entityInfo, crudRequest, true);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    result = CrudExecutor.checkArray(result, entityInfo, crudRequest);
                    return result;
                }
            });
            case CrudAction.SINGLE -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.single(session, entityInfo, crudRequest, false);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    result = CrudExecutor.checkArray(result, entityInfo, crudRequest);
                    return result;
                }
            });
            case CrudAction.LIST -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object list = CrudExecutor.list((EntityManager)session, entityInfo, crudRequest);
                    EntityHelper.loadLazy(list, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    list = CrudExecutor.checkArray(list, entityInfo, crudRequest);
                    return list;
                }
            });
            case CrudAction.CREATE -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.create(session, entityInfo, crudRequest);
                    EntityHelper.commit(session);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    return result;
                }
            });
            case CrudAction.UPDATE -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.update(session, entityInfo, crudRequest);
                    EntityHelper.commit(session);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    return result;
                }
            });
            case CrudAction.DELETE -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.delete(session, entityInfo, crudRequest);
                    EntityHelper.commit(session);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    return result;
                }
            });
            case CrudAction.DELETES -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.deletes(session, entityInfo, crudRequest);
                    EntityHelper.commit(session);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    return result;
                }
            });
            case CrudAction.MAP -> trxManagerInfo.transaction(new SessionCallable<T>(){

                @Override
                public T call(Session session) throws Exception {
                    Object result = CrudExecutor.map(session, entityInfo, crudRequest);
                    EntityHelper.loadLazy(result, entityInfo, crudRequest.getLoad(), crudRequest.getField());
                    result = CrudExecutor.createEntityByFields(result, entityInfo, crudRequest.getField());
                    return result;
                }
            });
            default -> throw new UnsupportedOperationException("Unsupported action: " + crudAction);
        };
    }

    public static <T> T list(EntityManager session, EntityInfo entityInfo, CrudRequest crudRequest) {
        EntityHelper.Builder builder = CrudHelper.builder(entityInfo, crudRequest, true);
        StringBuilder wql = new StringBuilder();
        EntityHelper.Where where = builder.getWhere();
        wql.append("from ").append(entityInfo.getEntityClass().getSimpleName()).append(" ").append(where.getAlias()).append(" ");
        if (where.getJoins() != null) {
            for (String[] ajoin : where.getJoins().values()) {
                wql.append("join ").append(ajoin[1]).append(" ").append(ajoin[0]).append(" ");
            }
        }
        if (!where.getQuery().isEmpty()) {
            wql.append(where.getQuery()).append(" ");
        }
        Integer start = crudRequest.getStart();
        Integer limit = crudRequest.getLimit();
        limit = limit != null && limit > 0 ? limit : net.ideahut.springboot.object.Page.DEFAULT_PAGE_SIZE;
        net.ideahut.springboot.object.Page page = crudRequest.getPage();
        if (page != null) {
            if (Boolean.TRUE.equals(page.getCount())) {
                Query query = session.createQuery("select count(" + where.getAlias() + ") " + wql.toString());
                if (where.getParameters() != null) {
                    for (int i = 0; i < where.getParameters().size(); ++i) {
                        query.setParameter(i + 1, where.getParameters().get(i));
                    }
                }
                Long records = (Long)query.getSingleResult();
                page.setRecords(records);
                if (records == 0L) {
                    return (T)page;
                }
            }
            start = (page.getIndex() - 1) * page.getSize();
            limit = page.getSize();
        }
        StringBuilder hql = new StringBuilder();
        if (!builder.getFieldQL().isEmpty()) {
            hql.append("select ").append(builder.getFieldQL()).append(" ").append(wql.toString());
        } else {
            hql.append("select ").append(where.getAlias()).append(" ").append(wql.toString());
        }
        if (!builder.getOrderQL().isEmpty()) {
            hql.append(" order by ").append(builder.getOrderQL());
        }
        Query query = session.createQuery(hql.toString());
        if (where.getParameters() != null) {
            for (int i = 0; i < where.getParameters().size(); ++i) {
                query.setParameter(i + 1, where.getParameters().get(i));
            }
        }
        if (start != null && start >= 0) {
            query.setFirstResult(start.intValue());
        }
        query.setMaxResults(limit.intValue());
        List data = query.getResultList();
        if (page != null) {
            page.setData(data);
            return (T)page;
        }
        return (T)data;
    }

    public static <T> T single(Session session, EntityInfo entityInfo, CrudRequest crudRequest, boolean unique) {
        Object result = null;
        Object id = crudRequest.getId();
        if (id != null) {
            IdInfo idInfo = entityInfo.getIdInfo();
            if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                CrudRequest compositeIdRequest = new CrudRequest();
                compositeIdRequest.setType(crudRequest.getType());
                ArrayList<EntityFilter> filter = new ArrayList<EntityFilter>();
                Map mapId = (Map)id;
                Iterator<String> iterator = idInfo.getFields().iterator();
                while (iterator.hasNext()) {
                    String compIdName;
                    Object compIdValue = mapId.get(compIdName = iterator.next());
                    filter.add(EntityFilter.and(compIdName, EntityFilter.Condition.EQUAL, compIdValue != null ? "" + compIdValue : null));
                }
                compositeIdRequest.setFilter(filter);
                compositeIdRequest.setLimit(2);
                List data = (List)CrudExecutor.list((EntityManager)session, entityInfo, compositeIdRequest);
                if (data != null && !data.isEmpty()) {
                    if (unique && data.size() > 1) {
                        throw BeanUtil.exception("Multiple data result");
                    }
                    result = data.get(0);
                }
            } else {
                result = session.find(entityInfo.getEntityClass(), id);
                if (1 == EntitySoftDelete.getDeleteStatus(result)) {
                    result = null;
                }
            }
        } else {
            crudRequest.setPage(null);
            crudRequest.setStart(null);
            crudRequest.setLimit(2);
            List data = (List)CrudExecutor.list((EntityManager)session, entityInfo, crudRequest);
            if (data != null && !data.isEmpty()) {
                if (unique && data.size() > 1) {
                    throw BeanUtil.exception("Multiple data result");
                }
                result = data.get(0);
            }
        }
        return (T)result;
    }

    public static <T> T create(Session session, EntityInfo entityInfo, CrudRequest crudRequest) {
        IdInfo idInfo = entityInfo.getIdInfo();
        Map<String, Object> value = crudRequest.getValue();
        Object idValue = null;
        switch (idInfo.getIdType()) {
            case EMBEDDED: {
                String idField = idInfo.getFields().iterator().next();
                idValue = crudRequest.getId();
                if (idValue == null && (idValue = value.remove(idField)) != null) {
                    idValue = mapper.convertValue(idValue, idInfo.getEmbeddedEntityInfo().getEntityClass());
                }
                value.put(idField, idValue);
                break;
            }
            case COMPOSITE: {
                for (String field : idInfo.getFields()) {
                    String idField = field;
                    idValue = value.remove(idField);
                    if (idValue != null) {
                        idValue = entityInfo.getFieldInfo(idField).convert("" + idValue);
                    }
                    value.put(idField, idValue);
                }
                break;
            }
            case STANDARD: {
                String idField = idInfo.getFields().iterator().next();
                FieldInfo idFieldInfo = entityInfo.getFieldInfo(idField);
                idValue = crudRequest.getId();
                if (idValue == null && (idValue = value.remove(idField)) != null) {
                    idValue = idFieldInfo.convert("" + idValue);
                }
                value.put(idField, idValue);
                break;
            }
        }
        Object entity = CrudHelper.mapToObject(value, entityInfo.getEntityClass());
        if (entity instanceof EntityAudit) {
            Long now = TimeUtil.currentEpochMillis();
            EntityAudit audit = (EntityAudit)entity;
            if (audit.getCreatedOn() == null) {
                audit.setCreatedOn(now);
            }
            if (audit.getUpdatedOn() == null) {
                audit.setUpdatedOn(now);
            }
        }
        session.persist(entity);
        return entity;
    }

    public static <T> T update(Session session, EntityInfo entityInfo, CrudRequest crudRequest) throws CommonException {
        T entity = CrudExecutor.single(session, entityInfo, crudRequest, true);
        if (entity == null) {
            throw new CommonException("Entity is not found");
        }
        entity = CrudHelper.invokeObject(entityInfo, entity, crudRequest.getValue(), true);
        session.merge(entity);
        return entity;
    }

    public static <T> T delete(Session session, EntityInfo entityInfo, CrudRequest crudRequest) {
        Object id = crudRequest.getId();
        if (id == null) {
            throw BeanUtil.exception("id is required");
        }
        T entity = CrudExecutor.single(session, entityInfo, crudRequest, true);
        if (entity != null) {
            session.remove(entity);
        }
        return entity;
    }

    public static <T> T deletes(Session session, EntityInfo entityInfo, CrudRequest crudRequest) {
        if (crudRequest.getIds() == null) {
            return null;
        }
        HashSet ids = new HashSet();
        for (Object id : crudRequest.getIds()) {
            if (id == null) continue;
            ids.add(id);
        }
        if (ids.isEmpty()) {
            return null;
        }
        IdInfo idInfo = entityInfo.getIdInfo();
        ArrayList<Object> list = new ArrayList<Object>();
        if (EntityIdType.EMBEDDED == idInfo.getIdType() || EntityIdType.STANDARD == idInfo.getIdType()) {
            String idField = idInfo.getFields().iterator().next();
            ArrayList params = new ArrayList();
            String hql = "from " + entityInfo.getEntityClass().getSimpleName() + " where " + idField + " in (?1) ";
            params.add(ids);
            if (EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass())) {
                hql = hql + "and deletedOn is null ";
            }
            org.hibernate.query.Query query = session.createQuery(hql, entityInfo.getEntityClass());
            int i = 1;
            while (!params.isEmpty()) {
                query.setParameter(i, params.remove(0));
                ++i;
            }
            List entities = query.getResultList();
            while (!entities.isEmpty()) {
                Object entity = entities.remove(0);
                session.remove(entity);
                list.add(entity);
            }
        } else if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
            for (Object id : ids) {
                CrudRequest request = new CrudRequest();
                request.setType(crudRequest.getType());
                request.setId(id);
                T entity = CrudExecutor.single(session, entityInfo, request, true);
                if (entity == null) continue;
                session.remove(entity);
                list.add(entity);
            }
        } else {
            BeanUtil.nothing();
        }
        return (T)list;
    }

    public static <T> T map(Session session, EntityInfo entityInfo, CrudRequest crudRequest) throws CommonException {
        String[] split;
        String mapkey = crudRequest.getMapkey();
        if (mapkey == null) {
            throw BeanUtil.exception("mapkey is required");
        }
        ArrayList<String> listkey = new ArrayList<String>();
        for (String key : split = mapkey.split(",")) {
            if ((key = key.trim()).isEmpty()) continue;
            listkey.add(key);
        }
        if (listkey.isEmpty()) {
            throw BeanUtil.exception("mapkey is empty");
        }
        crudRequest.setPage(null);
        List data = (List)CrudExecutor.list((EntityManager)session, entityInfo, crudRequest);
        LinkedHashMap result = new LinkedHashMap();
        if (data != null) {
            IdInfo idInfo = entityInfo.getIdInfo();
            for (Object object : data) {
                Object key;
                if (listkey.size() == 1) {
                    if (EntityIdType.EMBEDDED == idInfo.getIdType() && ((String)listkey.get(0)).equals(idInfo.getFields().iterator().next())) {
                        skey = new StringBuilder();
                        Object okey = entityInfo.getFieldInfo((String)listkey.get(0)).getValue(object);
                        EntityInfo embeddedIdInfo = idInfo.getEmbeddedEntityInfo();
                        for (String fieldName : embeddedIdInfo.getFieldInfoNames()) {
                            skey.append("~").append(fieldName).append(":").append(embeddedIdInfo.getFieldInfo(fieldName).getValue(okey).toString());
                        }
                        key = skey.toString().substring("~".length());
                    } else {
                        key = entityInfo.getFieldInfo((String)listkey.get(0)).getValue(object);
                    }
                } else {
                    skey = new StringBuilder();
                    for (String fieldName : listkey) {
                        skey.append("~").append(fieldName).append(":").append(entityInfo.getFieldInfo(fieldName).getValue(object).toString());
                    }
                    key = skey.toString().substring("~".length());
                }
                if (result.getOrDefault(key, null) != null) {
                    throw new CommonException("Duplicate key");
                }
                result.put(key, object);
            }
        }
        return (T)result;
    }

    private static Object checkArray(Object entity, EntityInfo entityInfo, CrudRequest crudRequest) throws CommonException {
        if (crudRequest.isNoarray()) {
            List<String> selectFields = crudRequest.getField();
            if (selectFields == null || selectFields.isEmpty()) {
                return entity;
            }
            if (entity instanceof Collection) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object object : (Collection)entity) {
                    list.add(CrudExecutor.createEntityByFields(object, entityInfo, selectFields));
                }
                return list;
            }
            if (entity instanceof net.ideahut.springboot.object.Page) {
                List list = ((net.ideahut.springboot.object.Page)entity).getData();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, CrudExecutor.createEntityByFields(list.get(i), entityInfo, selectFields));
                    }
                }
            } else if (entity instanceof Page) {
                List list = ((Page)entity).getContent();
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, CrudExecutor.createEntityByFields(list.get(i), entityInfo, selectFields));
                }
            } else if (entity instanceof Map) {
                Map map = (Map)entity;
                for (String key : map.keySet()) {
                    map.put(key, CrudExecutor.createEntityByFields(map.get(key), entityInfo, selectFields));
                }
            } else if (entity instanceof Object[]) {
                Object[] objects = entity;
                Object[] array = new Object[objects.length];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = CrudExecutor.createEntityByFields(objects[i], entityInfo, selectFields);
                }
                entity = array;
            } else {
                BeanUtil.nothing();
            }
        }
        return entity;
    }

    private static Object createEntityByFields(Object object, EntityInfo entityInfo, List<String> fields) throws CommonException {
        if (object != null && fields != null && !fields.isEmpty()) {
            Object[] rows = !(object instanceof Object[]) ? new Object[]{object} : (Object[])object;
            if (fields.size() < rows.length) {
                return object;
            }
            try {
                Object entity = BeanUtil.newInstance(entityInfo.getEntityClass());
                for (int i = 0; i < rows.length; ++i) {
                    FieldInfo fieldInfo;
                    if (rows[i] == null) continue;
                    String field = fields.get(i);
                    int idx = field.indexOf(".");
                    if (idx != -1) {
                        String fname;
                        FieldInfo finfo;
                        fieldInfo = entityInfo.getFieldInfo(field.substring(0, idx));
                        if (fieldInfo == null) continue;
                        Object fvalue = fieldInfo.getValue(entity);
                        EntityInfo einfo = entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                        if (fvalue == null) {
                            fvalue = BeanUtil.newInstance(einfo.getEntityClass());
                        }
                        if ((finfo = einfo.getFieldInfo(fname = field.substring(idx + 1))) != null) {
                            if (finfo.getConverter() instanceof EntityConverter) {
                                finfo.setValue(fvalue, rows[i]);
                            } else if (finfo.getConverter() instanceof CollectionConverter) {
                                finfo.setValue(fvalue, rows[i]);
                            } else if (fieldInfo.getConverter() != null) {
                                fieldInfo.setValue(entity, fieldInfo.getConverter().convert(Arrays.asList("" + rows[i])));
                            } else {
                                fieldInfo.setValue(entity, rows[i]);
                            }
                        }
                        fieldInfo.setValue(entity, fvalue);
                        continue;
                    }
                    fieldInfo = entityInfo.getFieldInfo(field);
                    if (fieldInfo == null) continue;
                    if (fieldInfo.getConverter() instanceof EntityConverter) {
                        fieldInfo.setValue(entity, rows[i]);
                        continue;
                    }
                    if (fieldInfo.getConverter() instanceof CollectionConverter) {
                        fieldInfo.setValue(entity, rows[i]);
                        continue;
                    }
                    if (fieldInfo.getConverter() != null) {
                        fieldInfo.setValue(entity, fieldInfo.getConverter().convert(Arrays.asList("" + rows[i])));
                        continue;
                    }
                    fieldInfo.setValue(entity, rows[i]);
                }
                return entity;
            }
            catch (Exception e) {
                throw new CommonException(e);
            }
        }
        return object;
    }
}

