/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudEntity;
import net.ideahut.springboot.crud.CrudExecutor;
import net.ideahut.springboot.crud.CrudField;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper;
import net.ideahut.springboot.crud.CrudId;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.util.BeanUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CrudHandlerImpl
implements CrudHandler,
InitializingBean,
BeanUtil.BeanConfigure<CrudHandler> {
    private final Map<String, Map<String, CrudEntity>> crudEntitiesByName = new HashMap<String, Map<String, CrudEntity>>();
    private final Map<String, Map<Class<?>, CrudEntity>> crudEntitiesByClass = new HashMap();
    private boolean reconfigured = false;
    private DataMapper dataMapper;
    private EntityTrxManager entityTrxManager;

    public CrudHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public CrudHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
    }

    @Override
    public Callable<CrudHandler> reconfigureBean(Collection<Object> arguments) {
        final CrudHandlerImpl self = this;
        return new Callable<CrudHandler>(){

            @Override
            public CrudHandler call() throws Exception {
                CrudHandlerImpl.this.reconfigure();
                CrudHandlerImpl.this.reconfigured = true;
                return self;
            }
        };
    }

    private void reconfigure() throws CommonException {
        this.crudEntitiesByName.clear();
        this.crudEntitiesByClass.clear();
        for (TrxManagerInfo trxManagerInfo : this.entityTrxManager.getTrxManagerInfos()) {
            String managerName = trxManagerInfo.getName();
            HashMap<String, CrudEntity> mapCrudEntity = this.crudEntitiesByName.getOrDefault(managerName, null);
            if (mapCrudEntity == null) {
                mapCrudEntity = new HashMap<String, CrudEntity>();
                this.crudEntitiesByName.put(managerName, mapCrudEntity);
                this.crudEntitiesByClass.put(managerName, new HashMap());
            }
            for (Class<?> entityClass : trxManagerInfo.getEntityClasses()) {
                EntityInfo entityInfo = trxManagerInfo.getEntityInfo(entityClass);
                String crudName = entityInfo.getCrudName();
                crudName = crudName != null ? crudName.trim() : "";
                if (crudName.isEmpty()) continue;
                if (mapCrudEntity.getOrDefault(crudName, null) != null) {
                    throw new CommonException("Duplicate crud name: " + crudName + ", manager: " + managerName);
                }
                CrudEntity crudEntity = CrudHandlerImpl.crudEntity(entityInfo);
                mapCrudEntity.put(crudName, crudEntity);
                this.crudEntitiesByClass.get(managerName).put(crudEntity.getEntityInfo().getEntityClass(), crudEntity);
            }
        }
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    @Override
    public DataMapper getDataMapper() {
        return this.dataMapper;
    }

    @Override
    public EntityTrxManager getEntityTrxManager() {
        return this.entityTrxManager;
    }

    @Override
    public <T> T execute(CrudAction action, EntityInfo entityInfo, CrudRequest request) throws CommonException {
        BeanUtil.checkBeanConfigure(this);
        return CrudExecutor.execute(entityInfo, action, request);
    }

    @Override
    public List<String> getCrudEntityNames(String managerName) {
        String string = managerName = managerName != null ? managerName : "";
        if (managerName.isEmpty()) {
            managerName = this.entityTrxManager.getDefaultTrxManagerInfo().getName();
        }
        Map map = this.crudEntitiesByName.getOrDefault(managerName, new HashMap());
        ArrayList<String> names = new ArrayList<String>(map.keySet());
        Collections.sort(names);
        return names;
    }

    @Override
    public Map<String, Set<CrudEntity>> getCrudEntityList(String managerName, String crudName) {
        managerName = managerName != null ? managerName : "";
        crudName = crudName != null ? crudName : "";
        LinkedHashMap<String, Set<CrudEntity>> result = new LinkedHashMap<String, Set<CrudEntity>>();
        if (!managerName.isEmpty()) {
            result.put(managerName, new TreeSet());
            Map map = this.crudEntitiesByName.getOrDefault(managerName, null);
            if (map != null) {
                if (!crudName.isEmpty()) {
                    CrudEntity crudEntity = map.getOrDefault(crudName, null);
                    if (crudEntity != null) {
                        ((Set)result.get(managerName)).add(crudEntity);
                    }
                } else {
                    ((Set)result.get(managerName)).addAll(map.values());
                }
            }
        } else if (!crudName.isEmpty()) {
            CrudEntity crudEntity;
            managerName = this.entityTrxManager.getDefaultTrxManagerInfo().getName();
            result.put(managerName, new TreeSet());
            Map map = this.crudEntitiesByName.getOrDefault(managerName, null);
            if (map != null && (crudEntity = (CrudEntity)map.getOrDefault(crudName, null)) != null) {
                ((Set)result.get(managerName)).add(crudEntity);
            }
        } else {
            for (Map.Entry<String, Map<String, CrudEntity>> entry : this.crudEntitiesByName.entrySet()) {
                result.put(entry.getKey(), new TreeSet<CrudEntity>(entry.getValue().values()));
            }
        }
        return result;
    }

    @Override
    public Map<String, Set<CrudEntity>> getCrudEntityList(String managerName, Class<?> entityClass) {
        managerName = managerName != null ? managerName : "";
        LinkedHashMap<String, Set<CrudEntity>> result = new LinkedHashMap<String, Set<CrudEntity>>();
        if (!managerName.isEmpty()) {
            result.put(managerName, new TreeSet());
            Map map = this.crudEntitiesByClass.getOrDefault(managerName, null);
            if (map != null) {
                if (entityClass != null) {
                    CrudEntity crudEntity = map.getOrDefault(entityClass, null);
                    if (crudEntity != null) {
                        ((Set)result.get(managerName)).add(crudEntity);
                    }
                } else {
                    ((Set)result.get(managerName)).addAll(map.values());
                }
            }
        } else if (entityClass != null) {
            CrudEntity crudEntity;
            managerName = this.entityTrxManager.getDefaultTrxManagerInfo().getName();
            result.put(managerName, new TreeSet());
            Map map = this.crudEntitiesByClass.getOrDefault(managerName, null);
            if (map != null && (crudEntity = (CrudEntity)map.getOrDefault(entityClass, null)) != null) {
                ((Set)result.get(managerName)).add(crudEntity);
            }
        } else {
            for (Map.Entry<String, Map<Class<?>, CrudEntity>> entry : this.crudEntitiesByClass.entrySet()) {
                result.put(entry.getKey(), new TreeSet<CrudEntity>(entry.getValue().values()));
            }
        }
        return result;
    }

    @Override
    public CrudRequest getCrudRequest(byte[] data, Class<?> entityClass) {
        return CrudHelper.getCrudRequest(this, data, entityClass);
    }

    @Override
    public CrudRequest getCrudRequest(byte[] data) {
        return CrudHelper.getCrudRequest(this, data, null);
    }

    @Override
    public CrudEntity getCrudEntity(String managerName, String crudName) {
        if (crudName != null) {
            Map map;
            if (managerName == null) {
                managerName = this.entityTrxManager.getDefaultTrxManagerInfo().getName();
            }
            if ((map = (Map)this.crudEntitiesByName.getOrDefault(managerName, null)) != null) {
                return map.getOrDefault(crudName, null);
            }
        }
        return null;
    }

    @Override
    public CrudEntity getCrudEntity(String managerName, Class<?> entityClass) {
        if (entityClass != null) {
            Map map;
            if (managerName == null) {
                managerName = this.entityTrxManager.getDefaultTrxManagerInfo().getName();
            }
            if ((map = (Map)this.crudEntitiesByClass.getOrDefault(managerName, null)) != null) {
                return map.getOrDefault(entityClass, null);
            }
        }
        return null;
    }

    private static CrudEntity crudEntity(EntityInfo entityInfo) {
        CrudId crudId = null;
        IdInfo idInfo = entityInfo.getIdInfo();
        if (idInfo != null) {
            CrudEntity embeddedIdEntity = null;
            EntityInfo embeddedIdInfo = idInfo.getEmbeddedEntityInfo();
            if (embeddedIdInfo != null) {
                embeddedIdEntity = new CrudEntity(embeddedIdInfo, null, null, CrudHandlerImpl.crudFields(embeddedIdInfo));
            }
            crudId = new CrudId(idInfo.getIdType(), idInfo.getFields(), embeddedIdEntity);
        }
        return new CrudEntity(entityInfo, entityInfo.getCrudName(), crudId, CrudHandlerImpl.crudFields(entityInfo));
    }

    private static List<CrudField> crudFields(EntityInfo entityInfo) {
        ArrayList<CrudField> crudFields = new ArrayList<CrudField>();
        for (String fieldInfoName : entityInfo.getFieldInfoNames()) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(fieldInfoName);
            String crudName = null;
            Boolean lazyObject = null;
            Boolean lazyCollection = null;
            if (entityInfo.getTrxManagerInfo() == null) continue;
            EntityInfo fieldEntityInfo = entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
            if (fieldEntityInfo != null && fieldEntityInfo.getCrudName() != null) {
                crudName = fieldEntityInfo.getCrudName();
                lazyObject = fieldInfo.isLazyObject();
            }
            if (fieldInfo.getConverter() instanceof CollectionConverter) {
                lazyCollection = fieldInfo.isLazyCollection();
            }
            CrudField crudField = new CrudField(fieldInfo.getName(), fieldInfo.getType().getSimpleName(), crudName, fieldInfo.getFormat(), null, lazyObject, lazyCollection, fieldInfo.getNullable(), fieldInfo.getLength(), fieldInfo.getScale(), fieldInfo.getPrecision(), fieldInfo.getColumnDefinition());
            crudFields.add(crudField);
        }
        for (String fieldName : entityInfo.getFieldTransientNames()) {
            Field field = entityInfo.getFieldTransient(fieldName);
            CrudField crudField = new CrudField(field.getName(), field.getType().getSimpleName(), null, null, true, null, null, null, null, null, null, null);
            crudFields.add(crudField);
        }
        return crudFields;
    }
}

