/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudHelper2;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.exception.CommonException;
import org.hibernate.Session;

public final class CrudHelper {
    private CrudHelper() {
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler, byte[] data) {
        return CrudHelper.getCrudRequest(crudHandler, data, null);
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler, byte[] data, Class<?> entityClass) {
        return CrudHelper1.getCrudRequest(crudHandler, data, entityClass);
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler) {
        return CrudHelper.getCrudRequest(crudHandler, (Class)null);
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler, Class<?> entityClass) {
        return CrudHelper1.getCrudRequest(crudHandler, entityClass);
    }

    public static <T> T invokeObject(EntityInfo entityInfo, T entity, Map<String, Object> value) throws CommonException {
        return CrudHelper.invokeObject(entityInfo, entity, value, false, null);
    }

    public static <T> T invokeObject(EntityInfo entityInfo, T entity, Map<String, Object> value, boolean isRefreshObject) throws CommonException {
        return CrudHelper.invokeObject(entityInfo, entity, value, isRefreshObject, null);
    }

    public static <T> T invokeObject(EntityInfo entityInfo, T entity, Map<String, Object> value, boolean isRefreshObject, Session session) throws CommonException {
        return CrudHelper2.invokeObject(entityInfo, entity, value, isRefreshObject, session);
    }

    public static EntityHelper.Builder builder(EntityInfo entityInfo, CrudRequest crudRequest, boolean forSelect) {
        return CrudHelper2.builder(entityInfo, crudRequest, forSelect);
    }

    public static Map<String, Object> nodeToValue(TreeNode node) {
        return CrudHelper0.nodeToValue(node);
    }

    public static Map<String, Object> nodeToMap(TreeNode node) {
        return CrudHelper0.nodeToMap(node);
    }

    public static void mapNameValue(Map<String, Object> map, String name, Object value) {
        CrudHelper0.mapNameValue(map, name, value);
    }

    public static Map<String, Object> stringToMap(String string) {
        return CrudHelper.stringToMap(string, null);
    }

    public static Map<String, Object> stringToMap(String string, Set<String> idFields) {
        return CrudHelper0.stringToMap(string, idFields);
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<?> type) {
        return CrudHelper0.mapToObject(map, type);
    }

    public static Map<String, Object> byteArrayToValue(byte[] data) {
        JsonNode node = CrudHelper0.readValue(data);
        return CrudHelper.nodeToValue((TreeNode)node);
    }

    public static <T> T stringToObject(String value, Class<?> type) {
        return CrudHelper0.stringToObject(value, type);
    }

    public static List<String> stringToList(String string) {
        return CrudHelper0.stringToList(string);
    }

    public static List<EntityFilter> stringToFilter(String string) {
        return CrudHelper0.stringToFilter(string);
    }

    public static List<EntityFilter> nodeToFilter(JsonNode node) {
        return CrudHelper0.nodeToFilter(node);
    }

    public static Map<String, Object> filterToMap(List<EntityFilter> filters) {
        return CrudHelper0.filterToMap(filters);
    }

    public static Object getIdObject(EntityInfo entityInfo, JsonNode node) {
        return CrudHelper0.getIdObject(entityInfo, node);
    }

    public static Object getIdObject(EntityInfo entityInfo, String value) {
        return CrudHelper0.getIdObject(entityInfo, value);
    }

    public static final class Split {
        public static final String ITEM = "~";
        public static final String KEYVAL = ":";
        public static final String FILTER = "--";
        public static final String ARRAY = ",";

        private Split() {
        }
    }

    public static final class Key {
        public static final String MANAGER = "manager";
        public static final String NAME = "name";
        public static final String MAPKEY = "mapkey";
        public static final String ID = "id";
        public static final String IDS = "ids";
        public static final String PAGE = "page";
        public static final String START = "start";
        public static final String LIMIT = "limit";
        public static final String FILTER = "filter";
        public static final String ORDER = "order";
        public static final String GROUP = "group";
        public static final String FIELD = "field";
        public static final String LOAD = "load";
        public static final String SIZEOF = "sizeof";
        public static final String VALUE = "value";
        public static final String VALUES = "values";
        public static final String NOARRAY = "noarray";
        public static final String CONDITION = "condition";

        private Key() {
        }
    }
}

