/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.exception.ResultRuntimeException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.BeanUtil;
import org.springframework.util.Assert;

final class CrudHelper0 {
    public static final DataMapper mapper = new DataMapperImpl(true);

    private CrudHelper0() {
    }

    public static Map<String, Object> filterToMap(List<EntityFilter> filters) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (filters == null) {
            return result;
        }
        for (EntityFilter filter : filters) {
            String[] names = filter.getField().split("\\.");
            LinkedHashMap<String, Object> temp = result;
            for (int i = 0; i < names.length - 1; ++i) {
                LinkedHashMap nmap = (LinkedHashMap)temp.get(names[i]);
                if (nmap == null) {
                    nmap = new LinkedHashMap();
                    temp.put(names[i], nmap);
                }
                temp = nmap;
            }
            temp.put(names[names.length - 1], filter);
        }
        return result;
    }

    public static Map<String, Object> nodeToValue(TreeNode node) {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            JsonNode item = (JsonNode)node.get(name);
            if (item.isNull()) {
                value.put(name, null);
                continue;
            }
            if (item.isContainerNode()) {
                value.put(name, CrudHelper0.nodeToMap((TreeNode)item));
                continue;
            }
            CrudHelper0.mapNameValue(value, name, item.asText());
        }
        return value;
    }

    public static Map<String, Object> nodeToMap(TreeNode node) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator iter = node.fieldNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            JsonNode item = (JsonNode)node.get(name);
            if (item.isContainerNode()) {
                map.put(name, CrudHelper0.nodeToMap((TreeNode)item));
                continue;
            }
            map.put(name, item.asText());
        }
        return map;
    }

    public static void mapNameValue(Map<String, Object> map, String name, Object value) {
        String[] names = name.split("\\.");
        LinkedHashMap<String, Object> temp = map;
        for (int i = 0; i < names.length - 1; ++i) {
            LinkedHashMap<String, Object> nmap = (LinkedHashMap<String, Object>)temp.get(names[i]);
            if (nmap == null) {
                nmap = new LinkedHashMap<String, Object>();
                temp.put(names[i], nmap);
            }
            temp = nmap;
        }
        temp.put(names[names.length - 1], value);
    }

    public static Map<String, Object> stringToMap(String string, Collection<String> idFields) {
        String[] items;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (string == null) {
            return result;
        }
        for (String item : items = string.split("~")) {
            String[] keyvals = item.split(":");
            if (keyvals.length == 2) continue;
            String[] names = keyvals[0].split("\\.");
            LinkedHashMap<String, Object> temp = result;
            for (int i = 0; i < names.length - 1; ++i) {
                LinkedHashMap nmap = (LinkedHashMap)temp.get(names[i]);
                if (nmap == null) {
                    nmap = new LinkedHashMap();
                    temp.put(names[i], nmap);
                }
                temp = nmap;
            }
            if (idFields != null && !idFields.contains(names[names.length - 1])) continue;
            temp.put(names[names.length - 1], keyvals[1]);
        }
        return result;
    }

    public static Object getIdObject(EntityInfo entityInfo, JsonNode node) {
        Object id = null;
        IdInfo idInfo = entityInfo.getIdInfo();
        switch (idInfo.getIdType()) {
            case EMBEDDED: {
                id = mapper.convert((Object)node, idInfo.getEmbeddedEntityInfo().getEntityClass());
                break;
            }
            case COMPOSITE: {
                id = CrudHelper0.nodeToMap((TreeNode)node);
                break;
            }
            case STANDARD: {
                id = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).convert(node.asText());
                break;
            }
        }
        return id;
    }

    public static Object getIdObject(EntityInfo entityInfo, String value) {
        Object id = null;
        IdInfo idInfo = entityInfo.getIdInfo();
        switch (idInfo.getIdType()) {
            case EMBEDDED: {
                id = CrudHelper0.stringToObject(value, idInfo.getEmbeddedEntityInfo().getEntityClass());
                break;
            }
            case COMPOSITE: {
                id = CrudHelper0.stringToMap(value, entityInfo.getIdInfo().getFields());
                break;
            }
            case STANDARD: {
                id = entityInfo.getFieldInfo(idInfo.getFields().iterator().next()).convert(value);
                break;
            }
        }
        return id;
    }

    public static <T> T stringToObject(String value, Class<?> type) {
        Map<String, Object> map = CrudHelper0.stringToMap(value, null);
        if (map.isEmpty()) {
            return null;
        }
        return (T)mapper.convert(map, type);
    }

    public static List<String> stringToList(String string) {
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        if (string == null) {
            return list;
        }
        for (String value : stringArray = string.split(",")) {
            if ((value = value.trim()).isEmpty()) continue;
            list.add(value);
        }
        return list;
    }

    public static List<EntityFilter> nodeToFilter(JsonNode node) {
        ArrayList<EntityFilter> filters = new ArrayList<EntityFilter>();
        Iterator iter = node.iterator();
        while (iter.hasNext()) {
            EntityFilter filter = new EntityFilter();
            JsonNode item = (JsonNode)iter.next();
            JsonNode jfilter = item.get("filter");
            if (jfilter != null) {
                List<EntityFilter> childfilters = CrudHelper0.nodeToFilter(jfilter);
                filter.setFilter(childfilters);
            }
            JsonNode jfield = item.get("field");
            if (jfilter == null) {
                Assert.notNull((Object)jfield, (String)"Filter field is required");
            }
            filter.setField(jfield != null ? jfield.asText().trim() : null);
            String strCondition = item.has("condition") ? item.get("condition").asText().trim() : "";
            EntityFilter.Condition condition = null;
            if (!strCondition.isEmpty()) {
                try {
                    condition = EntityFilter.Condition.valueOf(strCondition.toUpperCase());
                }
                catch (Exception e) {
                    condition = EntityFilter.Condition.of(strCondition.toLowerCase());
                }
            }
            if (condition == null) {
                condition = EntityFilter.Condition.EQUAL;
            }
            filter.setCondition(condition);
            JsonNode jlogical = item.get("logical");
            EntityFilter.Logical logical = EntityFilter.Logical.AND;
            if (jlogical != null) {
                logical = EntityFilter.Logical.of(jlogical.asText().trim(), EntityFilter.Logical.AND);
            }
            filter.setLogical(logical);
            JsonNode jvalue = item.get("value");
            if (jvalue != null) {
                ArrayList<String> lvalue = new ArrayList<String>();
                if (jvalue.isArray()) {
                    Iterator itervalue = jvalue.iterator();
                    while (itervalue.hasNext()) {
                        lvalue.add(((JsonNode)itervalue.next()).asText());
                    }
                } else {
                    lvalue.add(jvalue.asText());
                }
                filter.setValue(lvalue);
            } else {
                filter.setValue(new ArrayList<String>());
            }
            filters.add(filter);
        }
        return filters;
    }

    public static List<EntityFilter> stringToFilter(String string) {
        String[] items;
        ArrayList<EntityFilter> filters = new ArrayList<EntityFilter>();
        if (string == null) {
            return filters;
        }
        for (String item : items = string.split("~")) {
            String[] strFilters = item.split("--");
            if (strFilters.length < 3) {
                throw new ResultRuntimeException(Result.error("20", "Invalid filter length"));
            }
            EntityFilter.Logical logical = EntityFilter.Logical.AND;
            if (strFilters.length > 3) {
                String slogical = strFilters[0].trim().toLowerCase();
                if ("and".equals(slogical) || "or".equals(slogical)) {
                    logical = EntityFilter.Logical.valueOf(slogical);
                    strFilters = Arrays.copyOfRange(strFilters, 1, strFilters.length);
                }
                strFilters[2] = String.join((CharSequence)"--", Arrays.copyOfRange(strFilters, 2, strFilters.length));
            }
            String field = strFilters[0];
            EntityFilter.Condition condition = EntityFilter.Condition.of(strFilters[1], EntityFilter.Condition.EQUAL);
            String value = strFilters[2];
            EntityFilter filter = EntityFilter.of(logical, field, condition, value);
            filters.add(filter);
        }
        return filters;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<?> type) {
        if (map == null) {
            return null;
        }
        return (T)mapper.convert(map, type);
    }

    public static JsonNode readValue(Object value) {
        try {
            if (value instanceof byte[]) {
                return mapper.read((byte[])value, JsonNode.class);
            }
            if (value instanceof String) {
                return mapper.read((String)value, JsonNode.class);
            }
            throw BeanUtil.exception("Invalid type");
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }
}

