/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.crud.CrudEntity;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

final class CrudHelper1 {
    private CrudHelper1() {
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler, byte[] data, Class<?> entityClass) {
        JsonNode item;
        String limit;
        String start;
        JsonNode items;
        CrudEntity crudEntity;
        EntityTrxManager entityTrxManager = crudHandler.getEntityTrxManager();
        CrudRequest crudRequest = new CrudRequest();
        JsonNode node = CrudHelper0.readValue(data);
        String manager = node.has("manager") ? node.get("manager").asText().trim() : "";
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found: " + manager));
        }
        crudRequest.setManager(trxManagerInfo.getName());
        if (entityClass != null) {
            crudEntity = crudHandler.getCrudEntity(trxManagerInfo.getName(), entityClass);
        } else {
            String crudName = node.has("name") ? node.get("name").asText().trim() : "";
            crudEntity = crudHandler.getCrudEntity(trxManagerInfo.getName(), crudName);
        }
        Assert.notNull((Object)crudEntity, (String)"Entity is not found");
        EntityInfo entityInfo = crudEntity.getEntityInfo();
        crudRequest.setName(crudEntity.getCrudName());
        crudRequest.setType(entityInfo.getEntityClass());
        if (node.has("id")) {
            Object id = CrudHelper0.getIdObject(entityInfo, node.get("id"));
            crudRequest.setId(id);
        }
        if (node.has("ids") && (items = node.get("ids")).isArray()) {
            ArrayList<Object> ids = new ArrayList<Object>();
            for (JsonNode item2 : items) {
                ids.add(CrudHelper0.getIdObject(entityInfo, item2));
            }
            crudRequest.setIds(ids);
        }
        if (node.has("mapkey")) {
            crudRequest.setMapkey(node.get("mapkey").asText().trim());
        }
        if (node.has("page")) {
            Page page = CrudHelper0.mapper.convert((Object)node.get("page"), Page.class);
            crudRequest.setPage(page);
        }
        if (node.has("start") && !(start = node.get("start").asText().trim()).isEmpty()) {
            crudRequest.setStart(Integer.valueOf(start));
        }
        if (node.has("limit") && !(limit = node.get("limit").asText().trim()).isEmpty()) {
            crudRequest.setLimit(Integer.valueOf(limit));
        }
        if (node.has("filter")) {
            crudRequest.setFilter(CrudHelper0.nodeToFilter(node.get("filter")));
        }
        if (node.has("order")) {
            ArrayList<String> order = new ArrayList<String>();
            for (Object item3 : node.get("order")) {
                order.add(item3.asText().trim());
            }
            crudRequest.setOrder(order);
        }
        if (node.has("group")) {
            ArrayList<String> group = new ArrayList<String>();
            for (Object item3 : node.get("group")) {
                group.add(item3.asText().trim());
            }
            crudRequest.setGroup(group);
        }
        if (node.has("field")) {
            ArrayList<String> field = new ArrayList<String>();
            for (Object item3 : node.get("field")) {
                field.add(item3.asText().trim());
            }
            crudRequest.setField(field);
        }
        if (node.has("load")) {
            ArrayList<String> load = new ArrayList<String>();
            for (Object item3 : node.get("load")) {
                load.add(item3.asText().trim());
            }
            crudRequest.setLoad(load);
        }
        if (node.has("sizeof")) {
            ArrayList<String> sizeof = new ArrayList<String>();
            for (Object item3 : node.get("sizeof")) {
                sizeof.add(item3.asText().trim());
            }
            crudRequest.setSizeof(sizeof);
        }
        if (node.has("value") && (item = node.get("value")).isObject()) {
            crudRequest.setValue(CrudHelper0.nodeToValue((TreeNode)item));
        }
        if (node.has("values") && (items = node.get("values")).isArray()) {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            for (JsonNode item2 : items) {
                values.add(CrudHelper0.nodeToValue((TreeNode)item2));
            }
            crudRequest.setValues(values);
        }
        if (node.has("noarray")) {
            JsonNode noarray = node.get("noarray");
            String value = noarray.asText().trim().toLowerCase();
            boolean isfalse = "0".equals(value) || "false".equals(value);
            crudRequest.setNoarray(!isfalse);
        } else {
            crudRequest.setNoarray(true);
        }
        return crudRequest;
    }

    public static CrudRequest getCrudRequest(CrudHandler crudHandler, Class<?> entityClass) {
        String limit;
        String start;
        List<String> lpage;
        String mapkey;
        String[] ids;
        CrudEntity crudEntity;
        HttpServletRequest request = RequestContext.currentContext().getRequest();
        if (request == null) {
            return null;
        }
        EntityTrxManager entityTrxManager = crudHandler.getEntityTrxManager();
        CrudRequest crudRequest = new CrudRequest();
        String manager = request.getParameter("manager");
        manager = manager != null ? manager.trim() : "";
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found: " + manager));
        }
        crudRequest.setManager(trxManagerInfo.getName());
        if (entityClass != null) {
            crudEntity = crudHandler.getCrudEntity(trxManagerInfo.getName(), entityClass);
        } else {
            String crudName = request.getParameter("name");
            crudName = crudName != null ? crudName.trim() : "";
            crudEntity = crudHandler.getCrudEntity(trxManagerInfo.getName(), crudName);
        }
        Assert.notNull((Object)crudEntity, (String)"Entity is not found");
        EntityInfo entityInfo = crudEntity.getEntityInfo();
        crudRequest.setName(crudEntity.getCrudName());
        crudRequest.setType(entityInfo.getEntityClass());
        String id = request.getParameter("id");
        if (id != null) {
            Object idval = CrudHelper0.getIdObject(entityInfo, id);
            crudRequest.setId(idval);
        }
        if ((ids = request.getParameterValues("ids")) != null) {
            ArrayList<Object> cids = new ArrayList<Object>();
            for (String cid : ids) {
                cids.add(CrudHelper0.getIdObject(entityInfo, cid));
            }
            crudRequest.setIds(cids);
        }
        if ((mapkey = request.getParameter("mapkey")) != null) {
            crudRequest.setMapkey(mapkey.trim());
        }
        if ((lpage = CrudHelper0.stringToList(request.getParameter("page"))) != null && !lpage.isEmpty()) {
            Page page = Page.of(Integer.valueOf(lpage.get(0)));
            if (lpage.size() > 1) {
                page.setSize(Integer.valueOf(lpage.get(1).trim()));
            }
            if (lpage.size() > 2) {
                String count = lpage.get(2).trim().toLowerCase();
                page.setCount(!"0".equals(count) && !"false".equals(count));
            }
            crudRequest.setPage(page);
        }
        if ((start = request.getParameter("start")) != null && !(start = start.trim()).isEmpty()) {
            crudRequest.setStart(Integer.valueOf(start));
        }
        if ((limit = request.getParameter("limit")) != null && !(limit = limit.trim()).isEmpty()) {
            crudRequest.setLimit(Integer.valueOf(limit));
        }
        crudRequest.setFilter(CrudHelper0.stringToFilter(request.getParameter("filter")));
        crudRequest.setOrder(CrudHelper0.stringToList(request.getParameter("order")));
        crudRequest.setGroup(CrudHelper0.stringToList(request.getParameter("group")));
        crudRequest.setField(CrudHelper0.stringToList(request.getParameter("field")));
        crudRequest.setLoad(CrudHelper0.stringToList(request.getParameter("load")));
        crudRequest.setValue(CrudHelper0.stringToMap(request.getParameter("value"), null));
        return crudRequest;
    }
}

