/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.Query;

final class CrudHelper2 {
    private CrudHelper2() {
    }

    public static <T> T invokeObject(EntityInfo entityInfo, T entity, Map<String, Object> value, boolean isRefreshObject, Session session) throws CommonException {
        try {
            TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
            Object valueObject = CrudHelper0.mapper.convert(value, entityInfo.getEntityClass());
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(entry.getKey());
                if (fieldInfo == null) continue;
                Object mval = entry.getValue();
                if (mval != null) {
                    if (mval instanceof Map) {
                        final EntityInfo nextEntityInfo = trxManagerInfo.getEntityInfo(fieldInfo.getType());
                        if (nextEntityInfo == null) continue;
                        if (isRefreshObject) {
                            Object oldIdValue;
                            IdInfo nextIdInfo = nextEntityInfo.getIdInfo();
                            if (EntityIdType.COMPOSITE == nextIdInfo.getIdType()) {
                                Object freshEntity;
                                boolean isSetToNull = true;
                                for (String nextIdField : nextIdInfo.getFields()) {
                                    if (!((Map)mval).containsKey(nextIdField)) continue;
                                    Object mapIdValue = ((Map)mval).get(nextIdField);
                                    isSetToNull = isSetToNull && mapIdValue == null || "".equals("" + mapIdValue);
                                }
                                if (isSetToNull) {
                                    fieldInfo.setValue(entity, null);
                                    continue;
                                }
                                Object newEntity = CrudHelper0.mapper.convert(mval, nextEntityInfo.getEntityClass());
                                Object[] arrIdValue = new Object[nextIdInfo.getFields().size()];
                                Object oldEntity = fieldInfo.getValue(entity);
                                int i = 0;
                                boolean isContinue = true;
                                for (String nextIdField : nextIdInfo.getFields()) {
                                    Object nidValue;
                                    FieldInfo idFieldInfo = nextEntityInfo.getFieldInfo(nextIdField);
                                    arrIdValue[i] = nidValue = idFieldInfo.getValue(newEntity);
                                    Object oidValue = oldEntity != null ? idFieldInfo.getValue(oldEntity) : null;
                                    isContinue = isContinue && oidValue != null && oidValue.equals(nidValue);
                                    ++i;
                                }
                                if (isContinue) continue;
                                StringBuilder hql = new StringBuilder("from ").append(nextEntityInfo.getEntityClass().getSimpleName()).append(" a where 1=1 ");
                                final ArrayList<Object> parameters = new ArrayList<Object>();
                                i = 1;
                                for (String nextIdField : nextIdInfo.getFields()) {
                                    hql.append("and a.").append(nextIdField).append("=?").append(i);
                                    parameters.add(arrIdValue[i - 1]);
                                    ++i;
                                }
                                if (session != null) {
                                    Query query = session.createQuery(hql.toString());
                                    for (int j = 0; j < parameters.size(); ++j) {
                                        query.setParameter(j + 1, parameters.get(j));
                                    }
                                    query.setMaxResults(1);
                                    freshEntity = query.getSingleResult();
                                } else {
                                    final String fhql = hql.toString();
                                    freshEntity = trxManagerInfo.transaction(new SessionCallable<Object>(){

                                        @Override
                                        public Object call(Session session) throws Exception {
                                            Query query = session.createQuery(fhql);
                                            for (int j = 0; j < parameters.size(); ++j) {
                                                query.setParameter(j + 1, parameters.get(j));
                                            }
                                            query.setMaxResults(1);
                                            return query.getSingleResult();
                                        }
                                    });
                                }
                                if (freshEntity == null) continue;
                                fieldInfo.setValue(entity, freshEntity);
                                continue;
                            }
                            String nextIdField = nextIdInfo.getFields().iterator().next();
                            if (!((Map)mval).containsKey(nextIdField)) continue;
                            Object idValue = ((Map)mval).get(nextIdField);
                            if (idValue == null || "".equals("" + idValue)) {
                                fieldInfo.setValue(entity, null);
                                continue;
                            }
                            Object newEntity = CrudHelper0.mapper.convert(mval, nextEntityInfo.getEntityClass());
                            FieldInfo idFieldInfo = nextEntityInfo.getFieldInfo(nextIdField);
                            final Object newIdValue = idFieldInfo.getValue(newEntity);
                            if (newIdValue == null) continue;
                            Object oldEntity = fieldInfo.getValue(entity);
                            Object object = oldIdValue = oldEntity != null ? idFieldInfo.getValue(oldEntity) : null;
                            if (oldIdValue != null && oldIdValue.equals(newIdValue)) {
                                if (!fieldInfo.isLazyObject()) continue;
                                Hibernate.initialize((Object)oldEntity);
                                continue;
                            }
                            Object freshEntity = session != null ? session.get(nextEntityInfo.getEntityClass(), (Object)((Serializable)newIdValue)) : trxManagerInfo.transaction(new SessionCallable<Object>(){

                                @Override
                                public Object call(Session session) throws Exception {
                                    return session.get(nextEntityInfo.getEntityClass(), (Object)((Serializable)newIdValue));
                                }
                            });
                            if (freshEntity == null) continue;
                            fieldInfo.setValue(entity, freshEntity);
                            continue;
                        }
                        Object fieldValue = BeanUtil.newInstance(fieldInfo.getType());
                        fieldValue = CrudHelper2.invokeObject(nextEntityInfo, fieldValue, (Map)mval, isRefreshObject, session);
                        fieldInfo.setValue(entity, fieldValue);
                        continue;
                    }
                    if (fieldInfo.getType().equals(mval.getClass())) {
                        fieldInfo.setValue(entity, mval);
                        continue;
                    }
                    fieldInfo.setValue(entity, fieldInfo.getValue(valueObject));
                    continue;
                }
                fieldInfo.setValue(entity, null);
            }
            return entity;
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static EntityHelper.Builder builder(EntityInfo entityInfo, CrudRequest crudRequest, boolean forSelect) {
        String prevname;
        EntityHelper.Where where = EntityHelper.where(entityInfo, crudRequest, forSelect);
        StringBuilder fieldQL = new StringBuilder();
        LinkedHashMap<String, String[]> qjoin = new LinkedHashMap<String, String[]>();
        if (crudRequest.getField() != null && !crudRequest.getField().isEmpty()) {
            int count = 0;
            for (String name : crudRequest.getField()) {
                String altname;
                int i;
                name = name.replace(".", "__");
                String[] expname = name.split("__");
                int lenname = expname.length;
                String sAlias = where.getAlias();
                String sName = expname[lenname - 1];
                if (lenname > 2) {
                    for (i = 1; i < lenname - 1; ++i) {
                        altname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, i + 1));
                        if (!qjoin.containsKey(altname)) {
                            if (where.getJoins().containsKey(altname)) {
                                qjoin.put(altname, where.getJoins().get(altname));
                                where.getJoins().remove(altname);
                            } else {
                                prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, i));
                                qjoin.put(altname, new String[]{"b" + ++count, where.getJoins().get(prevname)[0] + "." + expname[i]});
                            }
                        }
                        prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, lenname - 1));
                        sAlias = ((String[])qjoin.get(prevname))[0];
                        fieldQL.append(sAlias).append(".").append(sName).append(",");
                    }
                    continue;
                }
                if (lenname == 2) {
                    i = 0;
                    altname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, i + 1));
                    if (!qjoin.containsKey(altname)) {
                        if (where.getJoins().containsKey(altname)) {
                            qjoin.put(altname, where.getJoins().get(altname));
                            where.getJoins().remove(altname);
                        } else {
                            qjoin.put(altname, new String[]{"b" + ++count, sAlias + "." + expname[i]});
                        }
                    }
                    prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, lenname - 1));
                    sAlias = ((String[])qjoin.get(prevname))[0];
                    fieldQL.append(sAlias).append(".").append(sName).append(",");
                    continue;
                }
                sName = name;
                fieldQL.append(sAlias).append(".").append(sName).append(",");
            }
            if (fieldQL.length() != 0) {
                fieldQL.deleteCharAt(fieldQL.length() - 1);
            }
        }
        for (String key : where.getJoins().keySet()) {
            qjoin.put(key, where.getJoins().get(key));
        }
        where.setJoins(qjoin);
        StringBuilder orderQL = new StringBuilder();
        if (crudRequest.getOrder() != null && !crudRequest.getOrder().isEmpty()) {
            IdInfo idInfo = entityInfo.getIdInfo();
            for (String name : crudRequest.getOrder()) {
                name = name.replace(".", "__");
                boolean asc = true;
                if (name.startsWith("-")) {
                    asc = false;
                    name = name.substring(1);
                }
                String[] expname = name.split("__");
                int lenname = expname.length;
                Object sAlias = where.getAlias();
                String sName = expname[lenname - 1];
                if (lenname > 1) {
                    prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, lenname - 1));
                    if (idInfo.getFields().contains(prevname)) {
                        sAlias = (String)sAlias + "." + prevname;
                    } else {
                        String[] aliases = where.getJoins().get(prevname);
                        if (aliases != null && aliases.length != 0) {
                            sAlias = aliases[0];
                        } else {
                            sName = name.replace("__", ".");
                        }
                    }
                }
                orderQL.append((String)sAlias).append(".").append(sName).append(asc ? " asc" : " desc").append(",");
            }
            if (orderQL.length() != 0) {
                orderQL.deleteCharAt(orderQL.length() - 1);
            }
        }
        EntityHelper.Builder builder = new EntityHelper.Builder();
        builder.setWhere(where);
        builder.setFieldQL(fieldQL.toString());
        builder.setOrderQL(orderQL.toString());
        return builder;
    }
}

