/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.ideahut.springboot.util.BeanUtil;

public class EntityFilter
implements Serializable {
    private String field;
    private Condition condition;
    private Logical logical;
    private Collection<String> value;
    private List<EntityFilter> filter;

    public String getStringValue() {
        return this.value != null && !this.value.isEmpty() ? this.value.iterator().next() : "";
    }

    public static EntityFilter of(Logical logical, String field, Condition condition, String value) {
        return EntityFilter.of(logical, field, condition, Arrays.asList(value));
    }

    public static EntityFilter of(Logical logical, String field, Condition condition, Collection<String> value) {
        EntityFilter o = new EntityFilter();
        o.condition = condition;
        o.logical = logical;
        o.field = field;
        o.value = value;
        return o;
    }

    public static EntityFilter and(String field, Condition condition, Collection<String> value) {
        return EntityFilter.of(Logical.AND, field, condition, value);
    }

    public static EntityFilter and(String field, Condition condition, String value) {
        return EntityFilter.of(Logical.AND, field, condition, value);
    }

    public static EntityFilter or(String field, Condition condition, Collection<String> value) {
        return EntityFilter.of(Logical.OR, field, condition, value);
    }

    public static EntityFilter or(String field, Condition condition, String value) {
        return EntityFilter.of(Logical.OR, field, condition, value);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }

    public void setValue(Collection<String> value) {
        this.value = value;
    }

    public void setFilter(List<EntityFilter> filter) {
        this.filter = filter;
    }

    public String getField() {
        return this.field;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public Collection<String> getValue() {
        return this.value;
    }

    public List<EntityFilter> getFilter() {
        return this.filter;
    }

    public static enum Logical {
        AND,
        OR;


        public static Logical of(String value, Logical defaultValue) {
            for (Logical l : Logical.values()) {
                if (!l.name().equalsIgnoreCase(value)) continue;
                return l;
            }
            return defaultValue;
        }

        public static Logical of(String value) {
            return Logical.of(value, null);
        }
    }

    public static enum Condition {
        ANY_LIKE("anylike", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase() + "%");
            }
        }),
        ANY_START("anystart", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") like ?" + (index + 1), ("" + values[0]).toLowerCase() + "%");
            }
        }),
        ANY_END("anyend", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase());
            }
        }),
        ANY_EQUAL("anyeq", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") = ?" + (index + 1), ("" + values[0]).toLowerCase());
            }
        }),
        LIKE("like", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " like ?" + (index + 1), values[0]);
            }
        }),
        START("start", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " like ?" + (index + 1), values[0] + "%");
            }
        }),
        END("end", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " like ?" + (index + 1), "%" + values[0]);
            }
        }),
        NOT_ANY_LIKE("notanylike", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") not like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase() + "%");
            }
        }),
        NOT_ANY_START("notanystart", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") not like ?" + (index + 1), ("" + values[0]).toLowerCase() + "%");
            }
        }),
        NOT_ANY_END("notanyend", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") not like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase());
            }
        }),
        NOT_ANY_EQUAL("notanyeq", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " lower(" + field + ") != ?" + (index + 1), ("" + values[0]).toLowerCase());
            }
        }),
        NOT_LIKE("notlike", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " not like ?" + (index + 1), values[0]);
            }
        }),
        NOT_START("notstart", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " not like ?" + (index + 1), values[0] + "%");
            }
        }),
        NOT_END("notend", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " not like ?" + (index + 1), "%" + values[0]);
            }
        }),
        NOT_EQUAL("noteq", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " != ?" + (index + 1), values[0]);
            }
        }),
        BETWEEN("between", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                if (values.length != 2) {
                    throw BeanUtil.exception("Invalid 'BETWEEN' value");
                }
                return QueryAndParams.of(logic + " " + field + " between ?" + (index + 1) + " and ?" + (index + 2), values[0], values[1]);
            }
        }),
        NOT_NULL("notnull", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " is not null", new Object[0]);
            }
        }),
        IS_NULL("isnull", false, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " is null", new Object[0]);
            }
        }),
        GREATER_THAN("gt", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " > ?" + (index + 1), values[0]);
            }
        }),
        GREATER_EQUAL("ge", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " >= ?" + (index + 1), values[0]);
            }
        }),
        LESS_THAN("lt", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " < ?" + (index + 1), values[0]);
            }
        }),
        LESS_EQUAL("le", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + " <= ?" + (index + 1), values[0]);
            }
        }),
        IN("in", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                if (values.length == 0) {
                    throw BeanUtil.exception("Invalid 'in' value");
                }
                return QueryAndParams.of(logic + " " + field + " in (?" + (index + 1) + ")", values);
            }
        }),
        NOT_IN("notin", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                if (values.length == 0) {
                    throw BeanUtil.exception("Invalid 'notin' value");
                }
                return QueryAndParams.of(logic + " " + field + " not in (?" + (index + 1) + ")", values);
            }
        }),
        EQUAL("eq", true, new QueryAndParamsGetter(){

            @Override
            public QueryAndParams getQueryAndParams(String logic, int index, String field, Object ... values) {
                return QueryAndParams.of(logic + " " + field + "=?" + (index + 1), values[0]);
            }
        });

        private final String code;
        private final boolean convert;
        private final QueryAndParamsGetter queryAndParamsGetter;

        private Condition(String code, boolean convert, QueryAndParamsGetter queryAndParamsGetter) {
            this.code = code;
            this.convert = convert;
            this.queryAndParamsGetter = queryAndParamsGetter;
        }

        public String getCode() {
            return this.code;
        }

        public boolean isConvert() {
            return this.convert;
        }

        public QueryAndParamsGetter getQueryAndParamsGetter() {
            return this.queryAndParamsGetter;
        }

        public static Condition of(String code, Condition defaultCondition) {
            for (Condition c : Condition.values()) {
                if (!c.code.equalsIgnoreCase(code)) continue;
                return c;
            }
            return defaultCondition;
        }

        public static Condition of(String code) {
            return Condition.of(code, null);
        }
    }

    public static interface QueryAndParamsGetter {
        public QueryAndParams getQueryAndParams(String var1, int var2, String var3, Object ... var4);
    }

    public static final class Specific {
        private static final ThreadLocal<List<EntityFilter>> holder = new InheritableThreadLocal<List<EntityFilter>>();

        private Specific() {
        }

        public static void set(List<EntityFilter> filters) {
            holder.set(filters);
        }

        public static void add(EntityFilter filter) {
            List<EntityFilter> filters = holder.get();
            if (filters == null) {
                filters = new ArrayList<EntityFilter>();
                holder.set(filters);
            }
            filters.add(filter);
        }

        public static List<EntityFilter> get() {
            return holder.get();
        }

        public static void clear() {
            holder.remove();
        }
    }

    public static final class QueryAndParams {
        private String query = "";
        private List<Object> params = new ArrayList<Object>();

        public static QueryAndParams of(String query, Object ... params) {
            QueryAndParams queryAndParams = new QueryAndParams();
            if (query != null) {
                queryAndParams.query = query;
            }
            if (params != null) {
                for (Object param : params) {
                    queryAndParams.params.add(param);
                }
            }
            return queryAndParams;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Object> getParams() {
            return this.params;
        }
    }
}

