/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper0;
import net.ideahut.springboot.entity.EntityHelper1;
import net.ideahut.springboot.entity.EntityHelper2;
import net.ideahut.springboot.entity.EntityHelper3;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public final class EntityHelper {
    public static final String FIELD_NAME_SPLITTER = "\\.";

    private EntityHelper() {
    }

    public static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> tobeLoadFields) {
        EntityHelper.loadLazy(entity, entityInfo, tobeLoadFields, null);
    }

    public static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) {
        try {
            EntityHelper0.loadLazy(entity, entityInfo, loadFields, selectedFields);
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    public static FieldInfo getFieldInfo(EntityInfo entityInfo, String anyFieldName) {
        return EntityHelper1.getFieldInfo(entityInfo, anyFieldName, FIELD_NAME_SPLITTER);
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, Collection<String> value) {
        return EntityHelper1.getFieldValue(entityInfo, anyFieldName, FIELD_NAME_SPLITTER, value);
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, String value) {
        return EntityHelper1.getFieldValue(entityInfo, anyFieldName, FIELD_NAME_SPLITTER, value);
    }

    public static void commit(Session session) {
        if (session != null) {
            EntityHelper.commit(session.getTransaction());
        }
    }

    public static void commit(StatelessSession session) {
        if (session != null) {
            EntityHelper.commit(session.getTransaction());
        }
    }

    public static void commit(Transaction transaction) {
        block3: {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) break block3;
                    throw BeanUtil.exception(e);
                }
            }
        }
    }

    public static void rollback(Session session) {
        if (session != null) {
            EntityHelper.rollback(session.getTransaction());
        }
    }

    public static void rollback(StatelessSession session) {
        if (session != null) {
            EntityHelper.rollback(session.getTransaction());
        }
    }

    public static void rollback(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
    }

    public static void close(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
    }

    public static void close(StatelessSession session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
    }

    public static void close(Connection connection) {
        EntityHelper2.close(connection);
    }

    public static Where where(EntityInfo entityInfo, CrudRequest request, boolean forSelect) {
        return EntityHelper3.where(entityInfo, request, forSelect);
    }

    public static Object[] condition(int index, EntityInfo entityInfo, EntityFilter filter) {
        return EntityHelper.condition(index, entityInfo, filter.getField(), filter.getCondition(), filter.getLogical(), filter.getField(), filter.getValue());
    }

    public static Object[] condition(int index, EntityInfo entityInfo, String qlField, EntityFilter filter) {
        return EntityHelper.condition(index, entityInfo, qlField, filter.getCondition(), filter.getLogical(), filter.getField(), filter.getValue());
    }

    public static Object[] condition(int index, EntityInfo entityInfo, String qlField, EntityFilter.Condition condition, EntityFilter.Logical logical, String field, Collection<String> value) {
        return EntityHelper3.condition(index, entityInfo, qlField, condition, logical, field, value);
    }

    public static List<String> getCatalogs(DatabaseMetaData dbMetaData) throws SQLException {
        return EntityHelper2.getCatalogs(dbMetaData);
    }

    public static Table findTable(EntityIntegrator integrator, String name) {
        return EntityHelper2.findTable(integrator, name);
    }

    public static Column findColumn(Table table, String name) {
        return EntityHelper2.findColumn(table, name);
    }

    public static boolean isTableExist(EntityIntegrator integrator, Table table) {
        return EntityHelper2.isTableExist(integrator, table);
    }

    public static boolean createTable(EntityIntegrator integrator, Table table) {
        return EntityHelper2.createTable(integrator, table);
    }

    public static class Where {
        private String query = "";
        private String alias = "";
        private List<Object> parameters = new ArrayList<Object>();
        private Map<String, String[]> joins = new LinkedHashMap<String, String[]>();

        public void setQuery(String query) {
            this.query = query;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setParameters(List<Object> parameters) {
            this.parameters = parameters;
        }

        public void setJoins(Map<String, String[]> joins) {
            this.joins = joins;
        }

        public String getQuery() {
            return this.query;
        }

        public String getAlias() {
            return this.alias;
        }

        public List<Object> getParameters() {
            return this.parameters;
        }

        public Map<String, String[]> getJoins() {
            return this.joins;
        }
    }

    public static class Builder {
        private Where where;
        private String fieldQL;
        private String orderQL;

        public void setWhere(Where where) {
            this.where = where;
        }

        public void setFieldQL(String fieldQL) {
            this.fieldQL = fieldQL;
        }

        public void setOrderQL(String orderQL) {
            this.orderQL = orderQL;
        }

        public Where getWhere() {
            return this.where;
        }

        public String getFieldQL() {
            return this.fieldQL;
        }

        public String getOrderQL() {
            return this.orderQL;
        }
    }
}

