/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Hibernate;
import org.springframework.data.domain.Page;

final class EntityHelper0 {
    private EntityHelper0() {
    }

    private static boolean isLoadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) throws CommonException {
        boolean result = false;
        if (entity instanceof Collection) {
            Iterator iter = ((Collection)entity).iterator();
            while (iter.hasNext()) {
                EntityHelper0.loadLazy(iter.next(), entityInfo, loadFields, selectedFields);
            }
            result = true;
        } else if (entity instanceof net.ideahut.springboot.object.Page) {
            EntityHelper0.loadLazy(((net.ideahut.springboot.object.Page)entity).getData(), entityInfo, loadFields, selectedFields);
            result = true;
        } else if (entity instanceof Page) {
            EntityHelper0.loadLazy(((Page)entity).getContent(), entityInfo, loadFields, selectedFields);
            result = true;
        } else if (entity instanceof Map) {
            EntityHelper0.loadLazy(((Map)entity).values(), entityInfo, loadFields, selectedFields);
            result = true;
        } else {
            BeanUtil.nothing();
        }
        return result;
    }

    public static void loadLazy(Object entity, EntityInfo entityInfo, Collection<String> loadFields, Collection<String> selectedFields) throws CommonException {
        if (entity != null) {
            FieldInfo fieldInfo;
            if (loadFields == null) {
                loadFields = new ArrayList<String>();
            }
            if (EntityHelper0.isLoadLazy(entity, entityInfo, loadFields, selectedFields)) {
                return;
            }
            if (entity instanceof Object[]) {
                ArrayList<String> lSelectedFields = new ArrayList<String>();
                if (selectedFields != null) {
                    lSelectedFields.addAll(selectedFields);
                }
                try {
                    Object[] objects = (Object[])entity;
                    for (int i = 0; i < objects.length; ++i) {
                        EntityInfo entityInfo2;
                        FieldInfo fieldInfo2 = fieldInfo = lSelectedFields.size() > i ? entityInfo.getFieldInfo((String)lSelectedFields.get(i)) : null;
                        if (fieldInfo != null && fieldInfo.isLazyObject()) {
                            entityInfo2 = entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                            if (loadFields.contains(fieldInfo.getName())) {
                                if (!Hibernate.isInitialized((Object)objects[i])) {
                                    Hibernate.initialize((Object)objects[i]);
                                }
                            } else {
                                Iterator<FieldInfo> idInfo = entityInfo2.getIdInfo();
                                Object t = BeanUtil.newInstance(entityInfo2.getEntityClass());
                                for (String string : ((IdInfo)((Object)idInfo)).getFields()) {
                                    FieldInfo idFieldInfo = entityInfo2.getFieldInfo(string);
                                    idFieldInfo.setValue(t, idFieldInfo.getValue(objects[i]));
                                }
                                objects[i] = t;
                            }
                            for (FieldInfo fieldInfo3 : entityInfo2.getLazyObjectFields().values()) {
                                fieldInfo3.setValue(objects[i], null);
                            }
                            for (FieldInfo fieldInfo4 : entityInfo2.getLazyCollectionFields().values()) {
                                fieldInfo4.setValue(objects[i], null);
                            }
                            continue;
                        }
                        if (entityInfo == null || objects[i] == null) continue;
                        entityInfo2 = entityInfo.getTrxManagerInfo().getEntityInfo(objects[i].getClass());
                        EntityHelper0.loadLazy(objects[i], entityInfo2 != null ? entityInfo2 : entityInfo, null, null);
                    }
                }
                catch (Exception e) {
                    throw new CommonException(e);
                }
            }
            if (entityInfo != null && !entityInfo.getEntityClass().isAssignableFrom(entity.getClass())) {
                FieldInfo fieldInfo3;
                EntityInfo entityInfo2;
                if (selectedFields != null && selectedFields.size() == 1 && (entityInfo2 = entityInfo.getTrxManagerInfo().getEntityInfo(entity.getClass())) != null && (fieldInfo3 = entityInfo.getFieldInfo(selectedFields.iterator().next())) != null && fieldInfo3.isLazyObject()) {
                    if (!Hibernate.isInitialized((Object)entity)) {
                        Hibernate.initialize((Object)entity);
                    }
                    for (FieldInfo lazyObjectFieldInfo : entityInfo2.getLazyObjectFields().values()) {
                        lazyObjectFieldInfo.setValue(entity, null);
                    }
                    for (FieldInfo lazyCollectionFieldInfo : entityInfo2.getLazyCollectionFields().values()) {
                        lazyCollectionFieldInfo.setValue(entity, null);
                    }
                }
                return;
            }
            BeanUtil.nothing();
            if (!entity.getClass().isArray() && entityInfo != null) {
                TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
                try {
                    for (String fieldName : entityInfo.getFieldInfoNames()) {
                        EntityInfo entityInfo2;
                        fieldInfo = entityInfo.getFieldInfo(fieldName);
                        Object fieldObject = fieldInfo.fieldValue(entity);
                        if (fieldObject == null) continue;
                        if (fieldInfo.getConverter() instanceof EntityConverter) {
                            entityInfo2 = trxManagerInfo.getEntityInfo(fieldInfo.getType());
                            if (entityInfo2 == null) continue;
                            if (fieldInfo.isLazyObject()) {
                                if (loadFields.contains(fieldInfo.getName())) {
                                    if (!Hibernate.isInitialized((Object)fieldObject)) {
                                        Hibernate.initialize((Object)fieldObject);
                                    }
                                    for (FieldInfo lazyObjectFieldInfo : entityInfo2.getLazyObjectFields().values()) {
                                        lazyObjectFieldInfo.setValue(fieldObject, null);
                                    }
                                    for (FieldInfo lazyCollectionFieldInfo : entityInfo2.getLazyCollectionFields().values()) {
                                        lazyCollectionFieldInfo.setValue(fieldObject, null);
                                    }
                                } else {
                                    IdInfo idInfo = entityInfo2.getIdInfo();
                                    Object newFieldObject = BeanUtil.newInstance(entityInfo2.getEntityClass());
                                    for (String idFieldName : idInfo.getFields()) {
                                        FieldInfo idFieldInfo = entityInfo2.getFieldInfo(idFieldName);
                                        idFieldInfo.setValue(newFieldObject, idFieldInfo.getValue(fieldObject));
                                    }
                                    fieldInfo.setValue(entity, newFieldObject);
                                    fieldObject = fieldInfo.fieldValue(entity);
                                }
                            }
                            for (String fieldName2 : entityInfo2.getFieldInfoNames()) {
                                FieldInfo fieldInfo5 = entityInfo2.getFieldInfo(fieldName2);
                                if (fieldInfo5.getCollectionGenericType() == null && !entityInfo.getEntityClass().isAssignableFrom(fieldInfo5.getType())) continue;
                                fieldInfo5.setValue(fieldObject, null);
                            }
                            continue;
                        }
                        if (fieldInfo.getConverter() instanceof CollectionConverter) {
                            if (fieldInfo.isLazyCollection()) {
                                if (loadFields.contains(fieldInfo.getName())) {
                                    if (!Hibernate.isInitialized((Object)fieldObject)) {
                                        Hibernate.initialize((Object)fieldObject);
                                    }
                                } else {
                                    fieldObject = null;
                                    fieldInfo.setValue(entity, fieldObject);
                                }
                            }
                            if (fieldObject == null) continue;
                            entityInfo2 = trxManagerInfo.getEntityInfo(fieldInfo.getCollectionGenericType());
                            Collection collection = (Collection)fieldObject;
                            for (String string : collection) {
                                for (String fieldName2 : entityInfo2.getFieldInfoNames()) {
                                    FieldInfo fieldInfo2 = entityInfo2.getFieldInfo(fieldName2);
                                    if (fieldInfo2.getConverter() instanceof EntityConverter) {
                                        if (!fieldInfo2.isLazyObject() && fieldInfo2.getCollectionGenericType() == null && !entityInfo.getEntityClass().isAssignableFrom(fieldInfo2.getType())) continue;
                                        fieldInfo2.setValue(string, null);
                                        continue;
                                    }
                                    if (fieldInfo2.getConverter() instanceof CollectionConverter) {
                                        fieldInfo2.setValue(string, null);
                                        continue;
                                    }
                                    BeanUtil.nothing();
                                }
                            }
                            continue;
                        }
                        BeanUtil.nothing();
                    }
                }
                catch (Exception e) {
                    throw new CommonException(e);
                }
            }
        }
    }
}

