/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.Arrays;
import java.util.Collection;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.BeanUtil;

final class EntityHelper1 {
    private EntityHelper1() {
    }

    public static FieldInfo getFieldInfo(EntityInfo entityInfo, String anyFieldName, String fieldNameSplitter) {
        IdInfo idInfo;
        String[] fields = anyFieldName.split(fieldNameSplitter);
        TrxManagerInfo trxManagerInfo = entityInfo.getTrxManagerInfo();
        FieldInfo fieldInfo = entityInfo.getFieldInfo(fields[0]);
        if (fields.length > 1) {
            String[] nextFields;
            EntityInfo nextEntityInfo = trxManagerInfo.getEntityInfo(fieldInfo.getType());
            if (nextEntityInfo == null) {
                return null;
            }
            for (String nextAnyField : nextFields = Arrays.copyOfRange(fields, 1, fields.length)) {
                fieldInfo = EntityHelper1.getFieldInfo(nextEntityInfo, nextAnyField, fieldNameSplitter);
            }
        } else if (fieldInfo == null && (idInfo = entityInfo.getIdInfo()) != null && idInfo.getEmbeddedEntityInfo() != null) {
            fieldInfo = idInfo.getEmbeddedEntityInfo().getFieldInfo(fields[0]);
        }
        return fieldInfo;
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, String fieldNameSplitter, String value) {
        return EntityHelper1.getFieldValue(entityInfo, anyFieldName, fieldNameSplitter, Arrays.asList(value));
    }

    public static Object getFieldValue(EntityInfo entityInfo, String anyFieldName, String fieldNameSplitter, Collection<String> value) {
        try {
            String idField;
            boolean isEmbeddedId;
            FieldInfo fieldInfo = null;
            IdInfo idInfo = entityInfo.getIdInfo();
            boolean bl = isEmbeddedId = EntityIdType.EMBEDDED == idInfo.getIdType();
            if (isEmbeddedId && anyFieldName.startsWith((idField = idInfo.getFields().iterator().next()) + ".")) {
                fieldInfo = idInfo.getEmbeddedEntityInfo().getFieldInfo(anyFieldName.substring((idField + ".").length()));
            }
            if (fieldInfo == null && (fieldInfo = EntityHelper1.getFieldInfo(entityInfo, anyFieldName, fieldNameSplitter)) == null) {
                return null;
            }
            Converter converter = fieldInfo.getConverter();
            Object object = null;
            if (converter != null) {
                object = converter instanceof EntityConverter ? (Object)BeanUtil.newInstance(fieldInfo.getType()) : (converter instanceof CollectionConverter ? null : converter.convert(value));
            }
            return object;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }
}

