/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.query.NativeQuery;

final class EntityHelper2 {
    private static final Comparator<String> SORT_CATALOG = (o1, o2) -> o2.compareTo((String)o1);

    private EntityHelper2() {
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
    }

    public static List<String> getCatalogs(DatabaseMetaData dbMetaData) throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = dbMetaData.getCatalogs();
        while (rs.next()) {
            catalogs.add(rs.getString(1));
        }
        Collections.sort(catalogs, SORT_CATALOG);
        return catalogs;
    }

    public static boolean isTableExist(EntityIntegrator integrator, Table table) {
        Connection connection = null;
        try {
            connection = integrator.getConnection();
            DatabaseMetaData dbMetaData = connection.getMetaData();
            String url = dbMetaData.getURL();
            List<String> catalogs = EntityHelper2.getCatalogs(dbMetaData);
            String catalog = null;
            for (String cat : catalogs) {
                if (url.indexOf("databaseName=" + cat) == -1 && url.indexOf("/" + cat) == -1) continue;
                catalog = cat;
                break;
            }
            if (catalog == null) {
                catalog = table.getCatalog();
            }
            ResultSet rs = dbMetaData.getTables(catalog, table.getSchema(), table.getName(), new String[]{"TABLE"});
            boolean result = rs.next();
            rs.close();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
        finally {
            EntityHelper2.close(connection);
        }
    }

    public static boolean createTable(EntityIntegrator integrator, Table table) {
        int num = 0;
        boolean isTableExist = EntityHelper2.isTableExist(integrator, table);
        if (!isTableExist) {
            SessionImplementor session = null;
            try {
                String sql = EntityHelper2.sqlCreateTable(integrator, table);
                session = integrator.getSessionFactory().openSession();
                session.beginTransaction();
                NativeQuery query1 = session.createNativeQuery(sql);
                num = query1.executeUpdate();
                Iterator iter = table.getIndexes().values().iterator();
                while (iter.hasNext()) {
                    sql = EntityHelper2.sqlCreateIndex(integrator, (Index)iter.next());
                    NativeQuery query2 = session.createNativeQuery(sql);
                    query2.executeUpdate();
                }
                EntityHelper.commit((Session)session);
            }
            catch (Exception e) {
                try {
                    EntityHelper.rollback(session);
                    throw e;
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    throw throwable;
                }
            }
            EntityHelper.close((Session)session);
        }
        return num != 0;
    }

    public static Table findTable(EntityIntegrator integrator, String name) {
        Database database = integrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        Identifier identifier = database.toIdentifier(name);
        for (Table table : namespace.getTables()) {
            if (!table.getNameIdentifier().equals((Object)identifier)) continue;
            return table;
        }
        return null;
    }

    public static Column findColumn(Table table, String name) {
        Column column = table.getColumn(Identifier.toIdentifier((String)name));
        if (column == null) {
            column = table.getColumn(Identifier.toIdentifier((String)name, (boolean)true));
        }
        return column;
    }

    private static String sqlCreateTable(EntityIntegrator integrator, Table table) {
        String checkConstraint;
        MetadataImpl metadata = (MetadataImpl)integrator.getMetadata();
        SqlStringGenerationContext context = SqlStringGenerationContextImpl.fromConfigurationMap((JdbcEnvironment)integrator.getJdbcEnvironment(), (Database)metadata.getDatabase(), integrator.getSettings());
        Dialect dialect = context.getDialect();
        StringBuilder buf = new StringBuilder(table.hasPrimaryKey() ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(table.getQualifiedName(context)).append(" (");
        KeyValue idValue = table.getIdentifierValue();
        boolean identityColumn = idValue != null;
        String pkname = null;
        if (table.hasPrimaryKey() && identityColumn) {
            pkname = ((Column)table.getPrimaryKey().getColumns().iterator().next()).getQuotedName(dialect);
        }
        Iterator iter = table.getColumns().iterator();
        while (iter.hasNext()) {
            String columnComment;
            Column col = (Column)iter.next();
            buf.append(col.getQuotedName(dialect)).append(' ');
            if (identityColumn && col.getQuotedName(dialect).equals(pkname)) {
                if (dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                    buf.append(col.getSqlType((Metadata)metadata));
                }
                buf.append(' ').append(dialect.getIdentityColumnSupport().getIdentityColumnString(col.getSqlTypeCode((Mapping)metadata)));
            } else {
                buf.append(col.getSqlType((Metadata)metadata));
                String defaultValue = col.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            if (col.isUnique()) {
                String keyName = Constraint.generateName((String)"UK_", (Table)table, (Column[])new Column[]{col});
                UniqueKey uk = table.getOrCreateUniqueKey(keyName);
                uk.addColumn(col);
                buf.append(dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(col, context));
            }
            if (col.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                checkConstraint = col.getCheckConstraint();
                buf.append(" check (").append(checkConstraint).append(")");
            }
            if ((columnComment = col.getComment()) != null) {
                buf.append(dialect.getColumnComment(columnComment));
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (table.hasPrimaryKey()) {
            buf.append(", ").append(table.getPrimaryKey().sqlConstraintString(dialect));
        }
        buf.append(dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table, context));
        if (dialect.supportsTableCheck()) {
            Iterator checkConstraints = table.getCheckConstraintsIterator();
            while (checkConstraints.hasNext()) {
                checkConstraint = (String)checkConstraints.next();
                buf.append(", check (").append(checkConstraint).append(')');
            }
        }
        buf.append(')');
        if (table.getComment() != null) {
            buf.append(dialect.getTableComment(table.getComment()));
        }
        return buf.append(dialect.getTableTypeString()).toString();
    }

    private static String sqlCreateIndex(EntityIntegrator integrator, Index index) {
        MetadataImpl metadata = (MetadataImpl)integrator.getMetadata();
        SqlStringGenerationContext context = SqlStringGenerationContextImpl.fromConfigurationMap((JdbcEnvironment)integrator.getJdbcEnvironment(), (Database)metadata.getDatabase(), integrator.getSettings());
        Dialect dialect = context.getDialect();
        String tableName = index.getTable().getQualifiedName(context);
        String name = index.getQuotedName(dialect);
        StringBuilder buf = new StringBuilder("create").append(" index ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify((String)name)).append(" on ").append(tableName).append(" (");
        Iterator columns = index.getColumns().iterator();
        Map columnOrderMap = index.getColumnOrderMap();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            buf.append(column.getQuotedName(dialect));
            if (columnOrderMap.containsKey(column)) {
                buf.append(" ").append((String)columnOrderMap.get(column));
            }
            if (!columns.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }
}

