/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.util.BeanUtil;

final class EntityHelper3 {
    private EntityHelper3() {
    }

    public static Object[] condition(int index, EntityInfo entityInfo, String qlField, EntityFilter.Condition condition, EntityFilter.Logical logical, String field, Collection<String> values) {
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (condition.isConvert()) {
            for (String value : values) {
                Object ovalue = EntityHelper.getFieldValue(entityInfo, field, value);
                lvals.add(ovalue);
            }
        } else {
            for (String value : values) {
                lvals.add(value);
            }
        }
        EntityFilter.QueryAndParams queryAndParams = condition.getQueryAndParamsGetter().getQueryAndParams(logical.name().toLowerCase(), index, qlField, lvals.toArray());
        return new Object[]{queryAndParams.getQuery(), queryAndParams.getParams().get(0), queryAndParams.getParams().size() > 1 ? queryAndParams.getParams().get(1) : null};
    }

    public static EntityHelper.Where where(EntityInfo entityInfo, CrudRequest request, boolean forSelect) {
        List<EntityFilter> filters;
        int count = 0;
        String alias = "a" + count;
        Boolean isIgnoreSoftDelete = EntitySoftDelete.isIgnore();
        boolean isSoftDelete = EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass()) && (isIgnoreSoftDelete == null || !Boolean.TRUE.equals(isIgnoreSoftDelete));
        StringBuilder query = new StringBuilder("where ");
        if (isSoftDelete) {
            query.append(alias).append(".").append("deletedOn").append(" is null ");
        } else {
            query.append("1=1 ");
        }
        EntityHelper.Where where = new EntityHelper.Where();
        where.setQuery(query.toString());
        List<EntityFilter> specifics = EntityFilter.Specific.get();
        if (specifics != null && !specifics.isEmpty()) {
            for (EntityFilter filter : specifics) {
                EntityHelper3.prepareFilter(where, filter, alias, forSelect, entityInfo, count);
            }
        }
        if ((filters = request.getFilter()) != null && !filters.isEmpty()) {
            for (EntityFilter filter : filters) {
                EntityHelper3.prepareFilter(where, filter, alias, forSelect, entityInfo, count);
            }
        }
        where.setAlias(alias);
        return where;
    }

    private static void prepareFilter(EntityHelper.Where where, EntityFilter filter, String alias, boolean forSelect, EntityInfo entityInfo, int count) {
        String logic = " " + filter.getLogical().name().toLowerCase();
        StringBuilder query = new StringBuilder(where.getQuery());
        if (filter.getFilter() != null && !filter.getFilter().isEmpty()) {
            query.append(" ").append(logic).append(" (1=1 ");
            for (EntityFilter child : filter.getFilter()) {
                where.setQuery(query.toString());
                EntityHelper3.prepareFilter(where, child, alias, forSelect, entityInfo, count);
                query = new StringBuilder(where.getQuery());
            }
            query.append(") ");
            where.setQuery(query.toString());
            return;
        }
        if (filter.getField() == null) {
            throw BeanUtil.exception("Filter field is required");
        }
        IdInfo idInfo = entityInfo.getIdInfo();
        Object idql = "";
        String name = filter.getField().replace(".", "__");
        String[] expname = name.split("__");
        int lenname = expname.length;
        String ialias = alias;
        String iname = expname[lenname - 1];
        if (forSelect) {
            if (EntityIdType.EMBEDDED == idInfo.getIdType() && expname[0].equals(idInfo.getFields().iterator().next())) {
                idql = ialias + "." + expname[0] + "." + iname;
            } else if (lenname > 1) {
                ++count;
                if (!where.getJoins().containsKey(expname[0])) {
                    where.getJoins().put(expname[0], new String[]{"a" + count + where.getJoins().size(), alias + "." + expname[0]});
                }
                for (int i = 0; i < lenname - 1; ++i) {
                    String altname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, i + 1));
                    if (where.getJoins().get(altname) != null) continue;
                    ++count;
                    String prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, i));
                    if (where.getJoins().containsKey(altname)) continue;
                    where.getJoins().put(altname, new String[]{"a" + count + where.getJoins().size(), where.getJoins().get(prevname)[0] + "." + expname[i]});
                }
                String prevname = String.join((CharSequence)"__", Arrays.copyOfRange(expname, 0, lenname - 1));
                ialias = where.getJoins().get(prevname)[0];
                idql = (String)idql + ialias + "." + iname;
            } else {
                iname = name;
                idql = (String)idql + ialias + "." + iname;
            }
        } else if (EntityIdType.EMBEDDED == idInfo.getIdType() && expname[0].equals(idInfo.getFields().iterator().next())) {
            idql = expname[0] + "." + iname;
        } else {
            iname = name;
            idql = (String)idql + iname;
        }
        EntityFilter.Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (condition.isConvert()) {
            for (String svalue : filter.getValue()) {
                Object ovalue = EntityHelper.getFieldValue(entityInfo, filter.getField(), svalue);
                lvals.add(ovalue);
            }
        } else {
            for (String svalue : filter.getValue()) {
                lvals.add(svalue);
            }
        }
        EntityFilter.QueryAndParams queryAndParams = condition.getQueryAndParamsGetter().getQueryAndParams(logic, where.getParameters().size(), (String)idql, lvals.toArray());
        query.append(queryAndParams.getQuery());
        where.getParameters().addAll(queryAndParams.getParams());
        where.setQuery(query.toString());
    }
}

