/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.annotation.Crud;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityHelper2;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.mapping.Table;

public class EntityInfo {
    private static final List<Class<?>> FIELD_ANNOTATIONS = Arrays.asList(GenericGenerator.class);
    @JsonIgnore
    private final TrxManagerInfo trxManagerInfo;
    private final Class<?> entityClass;
    private final String tableName;
    private final String tableSchema;
    private final String crudName;
    private final boolean isEntity;
    private final Map<String, Field> fieldTransients;
    private final Map<String, FieldInfo> fieldInfos;
    private final Map<String, FieldInfo> columnInfos;
    private final Map<String, FieldInfo> lazyObjectFields;
    private final Map<String, FieldInfo> lazyCollectionFields;
    private final Set<String> uniqueFields;
    private final Map<Class<? extends Annotation>, Set<String>> annotationFields;
    private final IdInfo idInfo;
    private final Table table;
    @JsonIgnore
    private EntityInfo parentInfo;

    public EntityInfo(TrxManagerInfo trxManagerInfo, Class<?> entityClass) throws Exception {
        Entity annotEntity = entityClass.getAnnotation(Entity.class);
        boolean isEntityEi = annotEntity != null;
        String tableSchemaEi = "";
        String tableNameEi = "";
        jakarta.persistence.Table annotTable = entityClass.getAnnotation(jakarta.persistence.Table.class);
        if (annotTable != null) {
            tableNameEi = annotTable.name();
            tableSchemaEi = annotTable.schema();
        }
        Table tableEi = null;
        if (trxManagerInfo != null && (tableEi = EntityHelper.findTable(trxManagerInfo.getIntegrator(), tableNameEi)) != null && tableEi.getSchema() != null) {
            tableSchemaEi = tableEi.getSchema();
        }
        String crudNameEi = null;
        Crud annotCrud = entityClass.getAnnotation(Crud.class);
        if (annotCrud != null && annotCrud.enable() && (crudNameEi = annotCrud.name().trim()).isEmpty()) {
            crudNameEi = entityClass.getSimpleName();
        }
        HashMap<String, Field> fieldTransientsEi = new HashMap<String, Field>();
        HashMap<String, FieldInfo> fieldInfosEi = new HashMap<String, FieldInfo>();
        HashMap<String, FieldInfo> columnInfosEi = new HashMap<String, FieldInfo>();
        HashMap<String, FieldInfo> lazyObjectFieldsEi = new HashMap<String, FieldInfo>();
        HashMap<String, FieldInfo> lazyCollectionFieldsEi = new HashMap<String, FieldInfo>();
        HashMap<Class<? extends Annotation>, Set<String>> annotationFieldsEi = new HashMap<Class<? extends Annotation>, Set<String>>();
        HashSet<String> uniqueFieldsEi = new HashSet<String>();
        HashSet<String> idFields = new HashSet<String>();
        EntityInfo embeddedEntityInfo = null;
        for (Class<?> theClass = entityClass; theClass != null; theClass = theClass.getSuperclass()) {
            for (Field field : theClass.getDeclaredFields()) {
                EntityInfo idEmbeddedInfo;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isAbstract(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isNative(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers())) continue;
                boolean canPopulate = false;
                if (Modifier.isPrivate(field.getModifiers())) {
                    String fieldName = field.getName();
                    String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        theClass.getMethod("get" + methodName, new Class[0]);
                        canPopulate = true;
                    }
                    catch (Exception e) {
                        BeanUtil.nothing();
                    }
                } else if (Modifier.isPublic(field.getModifiers())) {
                    canPopulate = true;
                } else {
                    BeanUtil.nothing();
                }
                if (!canPopulate || (idEmbeddedInfo = this.populate(field, fieldTransientsEi, fieldInfosEi, columnInfosEi, lazyObjectFieldsEi, lazyCollectionFieldsEi, idFields, uniqueFieldsEi, annotationFieldsEi)) == null) continue;
                embeddedEntityInfo = idEmbeddedInfo;
            }
        }
        IdInfo idInfoEi = new IdInfo();
        idInfoEi.setFields(idFields);
        if (idFields.size() > 1) {
            idInfoEi.setIdType(EntityIdType.COMPOSITE);
        } else if (idFields.size() == 1) {
            uniqueFieldsEi.add((String)idFields.iterator().next());
            if (embeddedEntityInfo != null) {
                idInfoEi.setEmbeddedEntityInfo(embeddedEntityInfo);
                idInfoEi.setIdType(EntityIdType.EMBEDDED);
            } else {
                idInfoEi.setIdType(EntityIdType.STANDARD);
                FieldInfo field = (FieldInfo)fieldInfosEi.get(idFields.iterator().next());
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                GenericGenerator genericGenerator = field.getAnnotation(GenericGenerator.class);
                idInfoEi.setGeneratedValue(generatedValue);
                idInfoEi.setGenericGenerator(genericGenerator);
            }
        } else {
            idInfoEi.setIdType(EntityIdType.NONE);
        }
        this.trxManagerInfo = trxManagerInfo;
        this.idInfo = idInfoEi;
        this.uniqueFields = Collections.unmodifiableSet(uniqueFieldsEi);
        this.fieldTransients = Collections.unmodifiableMap(fieldTransientsEi);
        this.fieldInfos = Collections.unmodifiableMap(fieldInfosEi);
        this.lazyObjectFields = Collections.unmodifiableMap(lazyObjectFieldsEi);
        this.lazyCollectionFields = Collections.unmodifiableMap(lazyCollectionFieldsEi);
        this.columnInfos = Collections.unmodifiableMap(columnInfosEi);
        this.annotationFields = Collections.unmodifiableMap(annotationFieldsEi);
        this.entityClass = entityClass;
        this.tableName = tableNameEi;
        this.tableSchema = tableSchemaEi;
        this.isEntity = isEntityEi;
        this.crudName = crudNameEi;
        this.table = tableEi;
    }

    public TrxManagerInfo getTrxManagerInfo() {
        return this.trxManagerInfo;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.entityClass.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.entityClass.getAnnotationsByType(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.entityClass.getAnnotations();
    }

    public Set<String> getAnnotationFields(Class<? extends Annotation> annotationClass) {
        return this.annotationFields.get(annotationClass);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public Field getFieldTransient(String name) {
        return this.fieldTransients.get(name);
    }

    public Set<String> getFieldTransientNames() {
        return this.fieldTransients.keySet();
    }

    public FieldInfo getFieldInfo(String name) {
        return this.fieldInfos.get(name);
    }

    public Set<String> getFieldInfoNames() {
        return this.fieldInfos.keySet();
    }

    public FieldInfo getColumnInfo(String name) {
        return this.columnInfos.get(name);
    }

    public Set<String> getColumnInfoNames() {
        return this.columnInfos.keySet();
    }

    public Map<String, FieldInfo> getLazyObjectFields() {
        return this.lazyObjectFields;
    }

    public Map<String, FieldInfo> getLazyCollectionFields() {
        return this.lazyCollectionFields;
    }

    public boolean isUniqueField(String field) {
        return this.uniqueFields.contains(field);
    }

    public IdInfo getIdInfo() {
        return this.idInfo;
    }

    public EntityInfo getParentInfo() {
        return this.parentInfo;
    }

    public String getCrudName() {
        return this.crudName;
    }

    public EntityInfo loadLazy(Object object, List<String> tobeLoadFields) {
        EntityHelper.loadLazy(object, this, tobeLoadFields);
        return this;
    }

    public EntityInfo nullLazyCollection(Object object) {
        if (object != null && this.entityClass.isAssignableFrom(object.getClass())) {
            try {
                for (FieldInfo fieldInfo : this.lazyCollectionFields.values()) {
                    fieldInfo.setValue(object, null);
                }
            }
            catch (Exception e) {
                throw BeanUtil.exception(e);
            }
        }
        return this;
    }

    public EntityInfo copy(Object source, Object target, Collection<String> skipFields) {
        return this.copy(source, target, true, skipFields);
    }

    public EntityInfo copy(Object source, Object target) {
        return this.copy(source, target, true, null);
    }

    public EntityInfo copy(Object source, Object target, boolean isSkipNull, Collection<String> skipFields) {
        if (source != null && target != null) {
            if (!this.entityClass.isAssignableFrom(source.getClass()) && !source.getClass().isAssignableFrom(this.entityClass)) {
                throw BeanUtil.exception("Invalid source class");
            }
            if (!this.entityClass.isAssignableFrom(target.getClass()) && !target.getClass().isAssignableFrom(this.entityClass)) {
                throw BeanUtil.exception("Invalid target class");
            }
            HashSet<String> ignoredFields = new HashSet<String>();
            if (skipFields != null) {
                ignoredFields.addAll(skipFields);
            }
            if (EntitySoftDelete.class.isAssignableFrom(this.entityClass)) {
                ignoredFields.add("deletedOn");
            }
            if (EntityAudit.class.isAssignableFrom(this.entityClass)) {
                ignoredFields.addAll(EntityAudit.Name.Field.list());
            }
            try {
                for (FieldInfo fieldInfo : this.fieldInfos.values()) {
                    Object value;
                    if (ignoredFields.contains(fieldInfo.getName()) || (value = fieldInfo.getValue(source)) == null && isSkipNull) continue;
                    fieldInfo.setValue(target, value);
                }
            }
            catch (Exception e) {
                throw BeanUtil.exception(e);
            }
        }
        return this;
    }

    public EntityInfo prepare() {
        Converter converter;
        Class<?> type;
        for (FieldInfo fieldInfo : this.fieldInfos.values()) {
            type = fieldInfo.getType();
            converter = Converter.of(type);
            if (converter == null && this.trxManagerInfo.getEntityInfo(type) != null) {
                converter = new EntityConverter(type);
            }
            fieldInfo.setConverter(converter);
        }
        if (EntityIdType.EMBEDDED == this.idInfo.getIdType()) {
            for (FieldInfo fieldInfo : this.idInfo.getEmbeddedEntityInfo().fieldInfos.values()) {
                type = fieldInfo.getType();
                converter = Converter.of(type);
                if (converter == null && this.trxManagerInfo.getEntityInfo(type) != null) {
                    converter = new EntityConverter(type);
                }
                fieldInfo.setConverter(converter);
            }
        }
        return this;
    }

    private EntityInfo populate(Field field, Map<String, Field> fieldTransients, Map<String, FieldInfo> fieldInfos, Map<String, FieldInfo> columnInfos, Map<String, FieldInfo> lazyObjectFields, Map<String, FieldInfo> lazyCollectionFields, Set<String> idFields, Set<String> uniqueFields, Map<Class<? extends Annotation>, Set<String>> annotationFields) throws Exception {
        JoinColumn[] jcolumns;
        JoinColumns joinColumns;
        Annotation[] annotations;
        field.setAccessible(true);
        Transient annotTransient = EntityInfo.findAnnotation(Transient.class, field);
        if (annotTransient != null) {
            fieldTransients.put(field.getName(), field);
            return null;
        }
        String name = field.getName();
        Boolean nullable = null;
        Integer length = null;
        Integer scale = null;
        Integer precision = null;
        String columnDefinition = "";
        boolean included = false;
        Class<?> type = field.getType();
        boolean lazyObject = false;
        boolean lazyCollection = false;
        Class collectionGenericType = null;
        if (Collection.class.isAssignableFrom(type)) {
            OneToMany oneToMany = EntityInfo.findAnnotation(OneToMany.class, field);
            ManyToMany manyToMany = EntityInfo.findAnnotation(ManyToMany.class, field);
            if (oneToMany != null) {
                lazyCollection = FetchType.LAZY == oneToMany.fetch();
            } else if (manyToMany != null) {
                lazyCollection = FetchType.LAZY == manyToMany.fetch();
            } else {
                BeanUtil.nothing();
            }
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                collectionGenericType = (Class)parameterizedType.getActualTypeArguments()[0];
            }
        } else {
            ManyToOne manyToOne = EntityInfo.findAnnotation(ManyToOne.class, field);
            OneToOne oneToOne = EntityInfo.findAnnotation(OneToOne.class, field);
            if (manyToOne != null) {
                lazyObject = FetchType.LAZY == manyToOne.fetch();
            } else if (oneToOne != null) {
                lazyObject = FetchType.LAZY == oneToOne.fetch();
            } else {
                BeanUtil.nothing();
            }
        }
        String columnName = null;
        Column column = EntityInfo.findAnnotation(Column.class, field);
        JoinColumn joinColumn = EntityInfo.findAnnotation(JoinColumn.class, field);
        PrimaryKeyJoinColumn primaryKeyJoinColumn = EntityInfo.findAnnotation(PrimaryKeyJoinColumn.class, field);
        if (column != null) {
            columnName = !column.name().isEmpty() ? column.name() : field.getName();
            nullable = column.nullable();
            columnDefinition = column.columnDefinition();
            length = column.length();
            scale = column.scale();
            precision = column.precision();
            if (column.unique()) {
                uniqueFields.add(name);
            }
            included = true;
        } else if (primaryKeyJoinColumn != null) {
            columnName = !primaryKeyJoinColumn.name().isEmpty() ? primaryKeyJoinColumn.name() : field.getName();
            columnDefinition = primaryKeyJoinColumn.columnDefinition();
            included = true;
        } else if (joinColumn != null && !Collection.class.isAssignableFrom(type)) {
            columnName = !joinColumn.name().isEmpty() ? joinColumn.name() : field.getName();
            nullable = joinColumn.nullable();
            columnDefinition = joinColumn.columnDefinition();
            if (joinColumn.unique()) {
                uniqueFields.add(name);
            }
            included = true;
        } else {
            columnName = field.getName();
            included = true;
        }
        EmbeddedId embeddedId = EntityInfo.findAnnotation(EmbeddedId.class, field);
        if (!included && embeddedId == null) {
            return null;
        }
        if (columnDefinition.isEmpty()) {
            columnDefinition = null;
        }
        if ((annotations = EntityInfo.findAnnotations(field)) != null) {
            for (Annotation annotation : annotations) {
                JoinColumn[] annotationType = annotation.annotationType();
                if (annotationType.getName().startsWith("jakarta.persistence.") || FIELD_ANNOTATIONS.contains(annotationType)) continue;
                Set<String> fields = annotationFields.get(annotationType);
                if (fields == null) {
                    fields = new HashSet<String>();
                    annotationFields.put((Class<? extends Annotation>)annotationType, fields);
                }
                fields.add(field.getName());
            }
        }
        org.hibernate.mapping.Column tableColumn = null;
        if (this.table != null) {
            tableColumn = EntityHelper2.findColumn(this.table, columnName);
        }
        FieldInfo fieldInfo = new FieldInfo(this, field, columnName, tableColumn, lazyObject, lazyCollection, collectionGenericType, nullable, length, scale, precision, columnDefinition);
        fieldInfos.put(name, fieldInfo);
        if (columnName != null) {
            if (!columnInfos.containsKey(columnName) && !columnInfos.containsKey(columnName.toLowerCase())) {
                columnInfos.put(columnName, fieldInfo);
                columnInfos.put(columnName.toLowerCase(), fieldInfo);
            } else if (joinColumn == null) {
                columnInfos.put(columnName, fieldInfo);
                columnInfos.put(columnName.toLowerCase(), fieldInfo);
            }
        }
        if ((joinColumns = EntityInfo.findAnnotation(JoinColumns.class, field)) != null && (jcolumns = joinColumns.value()) != null) {
            for (JoinColumn jcolumn : jcolumns) {
                String jname = jcolumn.name();
                if (columnInfos.containsKey(jname) || columnInfos.containsKey(jname.toLowerCase())) continue;
                columnInfos.put(jname, fieldInfo);
            }
        }
        if (fieldInfo.isLazyObject()) {
            lazyObjectFields.put(name, fieldInfo);
        } else if (fieldInfo.isLazyCollection()) {
            lazyCollectionFields.put(name, fieldInfo);
        } else {
            BeanUtil.nothing();
        }
        EntityInfo embeddedIdInfo = null;
        if (embeddedId != null) {
            embeddedIdInfo = new EntityInfo(this.trxManagerInfo, field.getType());
            embeddedIdInfo.parentInfo = this;
            idFields.add(name);
        } else {
            Id id = EntityInfo.findAnnotation(Id.class, field);
            if (id != null) {
                idFields.add(name);
            }
        }
        return embeddedIdInfo;
    }

    private static <A extends Annotation> A findAnnotation(Class<A> clazz, Field field) {
        A annotation = field.getAnnotation(clazz);
        if (annotation == null) {
            String fieldName = field.getName();
            String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getter = null;
            try {
                getter = field.getDeclaringClass().getMethod("get" + methodName, new Class[0]);
                annotation = getter.getAnnotation(clazz);
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
        return annotation;
    }

    private static Annotation[] findAnnotations(Field field) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            String fieldName = field.getName();
            String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getter = null;
            try {
                getter = field.getDeclaringClass().getMethod("get" + methodName, new Class[0]);
                annotations = getter.getAnnotations();
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
        return annotations;
    }
}

