/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.transaction.PlatformTransactionManager;

public final class EntityIntegrator {
    public static final String SESSION_FACTORY = EntityIntegrator.class.getName() + "_SESSION_FACTORY";
    public static final String AUDIT_IDENTIFIER = "hibernate.audit_identifier";
    public static final String AUDIT_SESSION_FACTORY = "hibernate.audit_session_factory";
    private static Map<Class<?>, List<Field>> compositeIds = new HashMap();
    private static Map<Class<?>, List<IdGenerator>> generatorIds = new HashMap();
    private final ServiceRegistry serviceRegistry;
    private final Map<String, Object> settings;
    private final MetadataBuildingContext metadataBuildingContext;
    private final Metadata metadata;
    private final MetadataSources metadataSources;
    private final SessionFactoryImplementor sessionFactory;
    private final JdbcEnvironment jdbcEnvironment;

    private EntityIntegrator(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, Map<String, Object> settings, Collection<Class<?>> annotatedClasses) {
        Map<String, Object> settingsEi;
        Collection<Class<?>> annotatedClassesEi = null;
        if (transactionManager != null) {
            sae = new SettingsAndEntities(transactionManager);
            settingsEi = sae.settings;
            annotatedClassesEi = sae.entities;
        } else if (sessionFactory != null) {
            sae = new SettingsAndEntities(sessionFactory);
            settingsEi = sae.settings;
            annotatedClassesEi = sae.entities;
        } else {
            settingsEi = settings;
            annotatedClassesEi = annotatedClasses;
        }
        BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().enableAutoClose().build();
        StandardServiceRegistry serviceRegistryEi = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings(settingsEi).build();
        MetadataSources metadataSourcesEi = new MetadataSources((ServiceRegistry)serviceRegistryEi);
        if (annotatedClassesEi != null) {
            for (Class<?> annotatedClass : annotatedClassesEi) {
                metadataSourcesEi.addAnnotatedClass(annotatedClass);
                EntityIntegrator.findCompositeAndGeneratorId(annotatedClass);
            }
        }
        this.serviceRegistry = serviceRegistryEi;
        this.metadataSources = metadataSourcesEi;
        this.metadata = this.metadataSources.buildMetadata();
        this.sessionFactory = (SessionFactoryImplementor)this.metadata.getSessionFactoryBuilder().build();
        this.settings = Collections.unmodifiableMap(settingsEi);
        this.jdbcEnvironment = new JdbcEnvironmentImpl((ServiceRegistryImplementor)this.serviceRegistry, this.metadata.getDatabase().getDialect());
        MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistryEi);
        BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(serviceRegistryEi, (MetadataBuildingOptions)metadataBuildingOptions);
        metadataBuildingOptions.setBootstrapContext((BootstrapContext)bootstrapContext);
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
        this.metadataBuildingContext = new MetadataBuildingContextRootImpl("", (BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)metadataCollector);
        InternalHelper.registerListeners(this.sessionFactory);
    }

    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public Collection<Class<?>> getAnnotatedClasses() {
        return this.metadataSources.getAnnotatedClasses();
    }

    public Connection getConnection() throws SQLException {
        return ((ConnectionProvider)this.sessionFactory.getSessionFactoryOptions().getServiceRegistry().getService(ConnectionProvider.class)).getConnection();
    }

    public <T> T transaction(boolean autoCommit, SessionCallable<T> callable) {
        Transaction transaction = null;
        SessionImplementor session = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            T result = callable.call((Session)session);
            if (autoCommit) {
                EntityHelper.commit(transaction);
            }
            T t = result;
            return t;
        }
        catch (Exception e) {
            if (autoCommit) {
                EntityHelper.rollback(transaction);
            }
            throw BeanUtil.exception(e);
        }
        finally {
            EntityHelper.close((Session)session);
        }
    }

    public <T> T transaction(SessionCallable<T> callable) {
        return this.transaction(false, callable);
    }

    public void destroy() {
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
    }

    public static EntityIntegrator of(SessionFactory sessionFactory) {
        return new EntityIntegrator(null, sessionFactory, null, null);
    }

    public static EntityIntegrator of(Map<String, Object> settings, Collection<Class<?>> annotatedClasses) {
        return new EntityIntegrator(null, null, settings, annotatedClasses);
    }

    public static EntityIntegrator of(Map<String, Object> settings) {
        return new EntityIntegrator(null, null, settings, null);
    }

    public static EntityIntegrator of(PlatformTransactionManager transactionManager) {
        return new EntityIntegrator(transactionManager, null, null, null);
    }

    public static List<Field> getCompositeIds(Class<?> entityClass) {
        return compositeIds.get(entityClass);
    }

    public static boolean hasIdGenerator(Class<?> entityClass) {
        return generatorIds.containsKey(entityClass);
    }

    private static void findCompositeAndGeneratorId(Class<?> entityClass) {
        HashSet<Field> compositeIdFields = new HashSet<Field>();
        HashSet<IdGenerator> generatorIdFields = new HashSet<IdGenerator>();
        for (Class<?> theClass = entityClass; theClass != null; theClass = theClass.getSuperclass()) {
            for (Field field : theClass.getDeclaredFields()) {
                Id id = field.getAnnotation(Id.class);
                if (id == null) continue;
                compositeIdFields.add(field);
                GenericGenerator genericGenerator = field.getAnnotation(GenericGenerator.class);
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                if (genericGenerator == null && generatedValue == null) continue;
                generatorIdFields.add(new IdGenerator(field, genericGenerator, generatedValue));
            }
        }
        if (compositeIdFields.size() > 1 && compositeIds.getOrDefault(entityClass, null) == null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : compositeIdFields) {
                field.setAccessible(true);
                fields.add(field);
            }
            compositeIds.put(entityClass, Collections.unmodifiableList(fields));
        }
        if (!generatorIdFields.isEmpty() && generatorIds.getOrDefault(entityClass, null) == null) {
            generatorIds.put(entityClass, Collections.unmodifiableList(new ArrayList(generatorIdFields)));
        }
    }

    private static final class SettingsAndEntities {
        private Map<String, Object> settings;
        private Set<Class<?>> entities = new HashSet();

        private SettingsAndEntities(PlatformTransactionManager transactionManager) {
            Metamodel metamodel;
            EntityManagerFactory entityManagerFactory = SettingsAndEntities.entityManagerFactory(transactionManager);
            if (entityManagerFactory != null) {
                this.settings = entityManagerFactory.getProperties();
                metamodel = entityManagerFactory.getMetamodel();
                InternalHelper.registerListeners(entityManagerFactory);
            } else {
                SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)SettingsAndEntities.sessionFactory(transactionManager);
                if (sessionFactory != null) {
                    this.settings = sessionFactory.getProperties();
                    MetamodelImplementor metamodelEi = sessionFactory.getMetamodel();
                    metamodel = metamodelEi;
                } else {
                    throw BeanUtil.exception("Unsupported Transaction Manager: " + transactionManager.getClass());
                }
            }
            if (this.settings == null) {
                this.settings = new HashMap<String, Object>();
            }
            if (metamodel != null) {
                for (EntityType entityType : metamodel.getEntities()) {
                    this.entities.add(entityType.getJavaType());
                }
            }
        }

        private SettingsAndEntities(SessionFactory sessionFactory) {
            MetamodelImplementor metamodel = ((SessionFactoryImplementor)sessionFactory).getMetamodel();
            this.settings = sessionFactory.getProperties();
            for (EntityType entityType : metamodel.getEntities()) {
                this.entities.add(entityType.getJavaType());
            }
        }

        private static EntityManagerFactory entityManagerFactory(PlatformTransactionManager transactionManager) {
            try {
                return (EntityManagerFactory)transactionManager.getClass().getMethod("getEntityManagerFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
            }
            catch (Exception e) {
                BeanUtil.nothing();
                return null;
            }
        }

        private static SessionFactory sessionFactory(PlatformTransactionManager transactionManager) {
            try {
                return (SessionFactory)transactionManager.getClass().getMethod("getSessionFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
            }
            catch (Exception e) {
                BeanUtil.nothing();
                return null;
            }
        }
    }

    private static final class IdGenerator {
        private final Field field;
        private final GenericGenerator genericGenerator;
        private final GeneratedValue generatedValue;

        IdGenerator(Field field, GenericGenerator genericGenerator, GeneratedValue generatedValue) {
            this.field = field;
            this.genericGenerator = genericGenerator;
            this.generatedValue = generatedValue;
        }

        public Field getField() {
            return this.field;
        }

        public GenericGenerator getGenericGenerator() {
            return this.genericGenerator;
        }

        public GeneratedValue getGeneratedValue() {
            return this.generatedValue;
        }
    }
}

