/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.entity.EntityBase;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.QueryProducer;

public final class EntityNativeSql {
    private final String alias;
    private final String table;
    private final EntityInfo entityInfo;
    private final List<FieldInfo> idFieldInfos;
    private final Map<String, FieldInfo> nameFields;
    private final List<String> nonIdFieldNames;
    private final List<FieldInfo> selectFieldInfos = new ArrayList<FieldInfo>();

    private EntityNativeSql(EntityInfo entityInfo, String alias) {
        FieldInfo finfo;
        this.alias = alias;
        this.entityInfo = entityInfo;
        String schema = this.entityInfo.getTableSchema();
        this.table = (String)(!schema.isEmpty() ? schema + "." : "") + this.entityInfo.getTableName();
        IdInfo idInfo = entityInfo.getIdInfo();
        ArrayList<FieldInfo> mIdFieldInfos = new ArrayList<FieldInfo>();
        HashMap<Object, FieldInfo> mNameFields = new HashMap<Object, FieldInfo>();
        ArrayList<String> mNonIdFieldNames = new ArrayList<String>();
        ArrayList<String> allNames = new ArrayList<String>(entityInfo.getFieldInfoNames());
        HashSet<String> columns = new HashSet<String>();
        if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
            String idName = idInfo.getFields().iterator().next();
            allNames.remove(idName);
            EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
            for (String name : embeddedInfo.getFieldInfoNames()) {
                FieldInfo finfo2 = embeddedInfo.getFieldInfo(name);
                if (columns.contains(finfo2.getColumn())) continue;
                columns.add(finfo2.getColumn());
                mIdFieldInfos.add(finfo2);
                mNameFields.put(idName + "." + name, finfo2);
            }
        } else {
            for (String fname : idInfo.getFields()) {
                allNames.remove(fname);
                finfo = entityInfo.getFieldInfo(fname);
                if (columns.contains(finfo.getColumn())) continue;
                columns.add(finfo.getColumn());
                mIdFieldInfos.add(finfo);
                mNameFields.put(fname, finfo);
            }
        }
        for (String fname : allNames) {
            finfo = entityInfo.getFieldInfo(fname);
            if (columns.contains(finfo.getColumn())) continue;
            columns.add(finfo.getColumn());
            mNameFields.put(fname, finfo);
            mNonIdFieldNames.add(fname);
        }
        columns.clear();
        this.idFieldInfos = Collections.unmodifiableList(mIdFieldInfos);
        this.nameFields = Collections.unmodifiableMap(mNameFields);
        this.nonIdFieldNames = Collections.unmodifiableList(mNonIdFieldNames);
    }

    public String alias() {
        return this.alias;
    }

    public Class<?> entityClass() {
        return this.entityInfo.getEntityClass();
    }

    public int totalColumns() {
        return this.idFieldInfos.size() + this.selectFieldInfos.size();
    }

    public String columnSql() {
        return this.columnSql(false, null);
    }

    public String columnSql(boolean withAlias) {
        return this.columnSql(withAlias, null);
    }

    public String columnSql(boolean withAlias, Collection<String> excludeFields) {
        this.selectFieldInfos.clear();
        StringBuilder sbQl = new StringBuilder();
        int i = 0;
        for (FieldInfo idFieldInfo : this.idFieldInfos) {
            this.popColumnQl(sbQl, idFieldInfo, withAlias, i);
            ++i;
        }
        if (excludeFields != null) {
            for (String fname : this.nonIdFieldNames) {
                if (excludeFields.contains(fname)) continue;
                FieldInfo finfo = this.entityInfo.getFieldInfo(fname);
                this.selectFieldInfos.add(finfo);
                this.popColumnQl(sbQl, finfo, withAlias, i);
                ++i;
            }
        } else {
            for (String fname : this.nonIdFieldNames) {
                FieldInfo finfo = this.entityInfo.getFieldInfo(fname);
                this.selectFieldInfos.add(finfo);
                this.popColumnQl(sbQl, finfo, withAlias, i);
                ++i;
            }
        }
        if (sbQl.length() > 1) {
            sbQl.deleteCharAt(sbQl.length() - 1);
        }
        return sbQl.toString();
    }

    private void popColumnQl(StringBuilder sbQl, FieldInfo finfo, boolean withAlias, int i) {
        if (withAlias) {
            sbQl.append(this.alias).append(".").append(finfo.getColumn()).append(" as ").append(this.alias).append("_").append(i).append(",");
        } else {
            sbQl.append(finfo.getColumn()).append(" as ").append(this.alias).append("_").append(i).append(",");
        }
    }

    public String table(Integer index, boolean withAlias) {
        return this.table + (String)(index != null && index > 0 ? "_" + index : "") + (String)(withAlias ? " " + this.alias : "") + " ";
    }

    public String table(Integer index) {
        return this.table(index, false);
    }

    public String column(String name, boolean withAlias) {
        FieldInfo finfo = this.nameFields.get(name);
        if (finfo != null) {
            return (String)(withAlias ? this.alias + "." : "") + finfo.getColumn();
        }
        return "";
    }

    public String column(String name) {
        return this.column(name, false);
    }

    public void copy(Object source, Object target) {
        this.entityInfo.copy(source, target);
    }

    public EntityNativeSql clone() {
        return new EntityNativeSql(this.entityInfo, this.alias);
    }

    public <T> T valueOf(Object[] row, int start) throws CommonException {
        Object fconv;
        Object value;
        Object object = BeanUtil.newInstance(this.entityInfo.getEntityClass());
        int i = start;
        IdInfo idInfo = this.entityInfo.getIdInfo();
        if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
            FieldInfo finfo = this.entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
            Object id = finfo.getValue(object);
            if (id == null) {
                id = BeanUtil.newInstance(finfo.getType());
                finfo.setValue(object, id);
            }
            for (FieldInfo idFieldInfo : this.idFieldInfos) {
                Object value2 = row[i];
                if (value2 != null) {
                    Object fconv2 = idFieldInfo.convert("" + value2);
                    idFieldInfo.setValue(id, fconv2);
                }
                ++i;
            }
        } else {
            for (FieldInfo idFieldInfo : this.idFieldInfos) {
                value = row[i];
                if (value != null) {
                    fconv = idFieldInfo.convert("" + value);
                    idFieldInfo.setValue(object, fconv);
                }
                ++i;
            }
        }
        for (FieldInfo fieldInfo : this.selectFieldInfos) {
            value = row[i];
            if (value != null) {
                if (fieldInfo.getConverter() instanceof EntityConverter) {
                    EntityInfo feinfo = this.entityInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
                    if (feinfo != null) {
                        IdInfo fidi;
                        Object fobj = fieldInfo.getValue(object);
                        if (fobj == null) {
                            fobj = BeanUtil.newInstance(fieldInfo.getType());
                        }
                        if (EntityIdType.STANDARD.equals((Object)(fidi = feinfo.getIdInfo()).getIdType())) {
                            FieldInfo ffi = feinfo.getFieldInfo(fidi.getFields().iterator().next());
                            Object fcv = ffi.convert("" + value);
                            ffi.setValue(fobj, fcv);
                        }
                        fieldInfo.setValue(object, fobj);
                    }
                } else {
                    fconv = fieldInfo.convert("" + value);
                    fieldInfo.setValue(object, fconv);
                }
            }
            ++i;
        }
        return object;
    }

    public static EntityNativeSql create(TrxManagerInfo trxManagerInfo, Class<?> type, String alias) throws Exception {
        if (!EntityBase.class.isAssignableFrom(type)) {
            throw new Exception("Invalid entity: " + type.getName());
        }
        EntityInfo entityInfo = trxManagerInfo.getEntityInfo(type);
        if (entityInfo == null) {
            throw new Exception("Entity is not found: " + type.getName());
        }
        return new EntityNativeSql(entityInfo, alias);
    }

    public static String join(String type, EntityNativeSql sourceEntity, Integer sourceIndex, EntityNativeSql targetEntity, Collection<Join> joins) {
        String sourceTable = sourceEntity.table(sourceIndex, true);
        StringBuilder sql = new StringBuilder(type + " join " + sourceTable + " on ");
        boolean isFirst = true;
        for (Join join : joins) {
            sql.append(!isFirst ? "and " : "").append(sourceEntity.column(join.sourceFieldName, true)).append("=").append(targetEntity.column(join.targetFieldName, true)).append(" ");
            isFirst = false;
        }
        return sql.toString();
    }

    public static String join(String type, EntityNativeSql sourceEntity, Integer sourceIndex, EntityNativeSql targetEntity, Join join) {
        return EntityNativeSql.join(type, sourceEntity, sourceIndex, targetEntity, Arrays.asList(join));
    }

    public static String join(String type, EntityNativeSql sourceEntity, EntityNativeSql targetEntity, Collection<Join> joins) {
        return EntityNativeSql.join(type, sourceEntity, null, targetEntity, joins);
    }

    public static String join(String type, EntityNativeSql sourceEntity, EntityNativeSql targetEntity, Join join) {
        return EntityNativeSql.join(type, sourceEntity, null, targetEntity, Arrays.asList(join));
    }

    public static String filter(String logical, String function, EntityNativeSql entity, String name, boolean withAlias, String condition, Integer paramIndex) {
        Object result = "";
        result = !(function = EntityNativeSql.trim(function)).isEmpty() ? ("in".equals(condition) || "not in".equals(condition) ? logical + " " + function + "(" + entity.column(name, withAlias) + ") " + condition + " (?" + paramIndex + ") " : logical + " " + function + "(" + entity.column(name, withAlias) + ") " + condition + (String)(paramIndex != null ? " ?" + paramIndex : "") + " ") : ("in".equals(condition) || "not in".equals(condition) ? logical + " " + entity.column(name, withAlias) + " " + condition + " (?" + paramIndex + ") " : logical + " " + entity.column(name, withAlias) + " " + condition + (String)(paramIndex != null ? " ?" + paramIndex : "") + " ");
        return result;
    }

    public static String filter(String logical, EntityNativeSql entity, String name, boolean withAlias, String condition, Integer paramIndex) {
        return EntityNativeSql.filter(logical, null, entity, name, withAlias, condition, paramIndex);
    }

    public static String filter(String logical, String function, EntityNativeSql entity, String name, String condition, Integer paramIndex) {
        return EntityNativeSql.filter(logical, function, entity, name, false, condition, paramIndex);
    }

    public static String filter(String logical, EntityNativeSql entity, String name, String condition, Integer paramIndex) {
        return EntityNativeSql.filter(logical, null, entity, name, false, condition, paramIndex);
    }

    public static String order(EntityNativeSql entity, String sortBy, boolean withAlias, String defaultSort) {
        Object tSort = EntityNativeSql.trim(sortBy);
        if (((String)tSort).isEmpty()) {
            tSort = EntityNativeSql.trim(defaultSort);
        }
        if (!((String)tSort).isEmpty()) {
            StringBuilder bs = new StringBuilder();
            for (String s : ((String)tSort).split(",")) {
                if ((s = EntityNativeSql.trim(s)).isEmpty()) continue;
                if (s.startsWith("-")) {
                    bs.append(entity.column(s.substring(1), withAlias)).append(" desc,");
                    continue;
                }
                bs.append(entity.column(s, withAlias)).append(" asc,");
            }
            tSort = "";
            if (bs.length() > 1) {
                bs.deleteCharAt(bs.length() - 1);
                tSort = "order by " + bs.toString() + " ";
            }
        }
        return tSort;
    }

    public static String order(EntityNativeSql entity, String sortBy, String defaultSort) {
        return EntityNativeSql.order(entity, sortBy, false, defaultSort);
    }

    public static Long count(Session session, String fromSql, List<Object> parameters) {
        NativeQuery query = session.createNativeQuery("select count(1) " + fromSql);
        for (int i = 0; i < parameters.size(); ++i) {
            query.setParameter(i + 1, parameters.get(i));
        }
        return Long.valueOf("" + query.getSingleResult());
    }

    public static Boolean count(Session session, Page<?> result, String fromQl, List<Object> parameters) {
        if (Boolean.TRUE.equals(result.getCount())) {
            Long records = EntityNativeSql.count(session, fromQl, parameters);
            result.setRecords(records);
            if (records == 0L) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static List<Object[]> query(QueryProducer session, String sql, Page<?> page, List<Object> parameters) {
        NativeQuery query = session.createNativeQuery(sql);
        for (int i = 0; i < parameters.size(); ++i) {
            query.setParameter(i + 1, parameters.get(i));
        }
        query.setFirstResult((page.getIndex() - 1) * page.getSize());
        query.setMaxResults(page.getSize().intValue());
        return query.getResultList();
    }

    public static Object[] unique(QueryProducer session, String sql, List<Object> parameters) {
        NativeQuery query = session.createNativeQuery(sql);
        for (int i = 0; i < parameters.size(); ++i) {
            query.setParameter(i + 1, parameters.get(i));
        }
        query.setMaxResults(1);
        return (Object[])query.uniqueResult();
    }

    public static String trim(String text) {
        return text != null ? text.trim() : "";
    }

    public static class Join {
        private final String sourceFieldName;
        private final String targetFieldName;

        private Join(String sourceFieldName, String targetFieldName) {
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
        }

        public static Join on(String sourceFieldName, String targetFieldName) {
            return new Join(sourceFieldName, targetFieldName);
        }
    }
}

