/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.entity.EntityFilter;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.Page;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class EntityQuery<T> {
    private final TrxManagerInfo trxManagerInfo;
    private final CrudRequest crudRequest;
    private final Set<String> loadFields = new HashSet<String>();
    private final String alias;
    private StringBuilder query = new StringBuilder();
    private List<Object> parameters = new ArrayList<Object>();
    private Map<String, String> replace = new TreeMap<String, String>();
    private List<String> defaultOrders = new ArrayList<String>();
    private List<String> groups = new ArrayList<String>();
    private Map<String, FieldReplace> replaceFields = new HashMap<String, FieldReplace>();
    private List<String> selectFields;
    private Boolean ignorePopulateNull = Boolean.FALSE;
    private PopulateSelect<T> populateSelect;

    public EntityQuery(TrxManagerInfo trxManagerInfo, CrudRequest crudRequest, String alias) {
        this.trxManagerInfo = trxManagerInfo;
        this.crudRequest = crudRequest;
        if (crudRequest.getLoad() != null) {
            this.loadFields.addAll(crudRequest.getLoad());
        }
        this.alias = alias;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public EntityQuery<T> setQuery(String query) {
        this.query.append(query);
        return this;
    }

    public EntityQuery<T> setDefaultOrders(List<String> defaultOrders) {
        this.defaultOrders = defaultOrders;
        return this;
    }

    public EntityQuery<T> addDefaultOrder(String defaultOrder) {
        if (defaultOrder != null) {
            if (this.defaultOrders == null) {
                this.defaultOrders = new ArrayList<String>();
            }
            this.defaultOrders.add(defaultOrder);
        }
        return this;
    }

    public EntityQuery<T> setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public EntityQuery<T> addGroup(String group) {
        if (group != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(group);
        }
        return this;
    }

    public EntityQuery<T> addReplace(String field, String alias) {
        this.replace.put(field, alias);
        return this;
    }

    public EntityQuery<T> setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
        return this;
    }

    public EntityQuery<T> addSelectField(String selectField) {
        if (selectField != null) {
            if (this.selectFields == null) {
                this.selectFields = new ArrayList<String>();
            }
            this.selectFields.add(selectField);
        }
        return this;
    }

    public EntityQuery<T> addFieldReplace(String field, Class<?> clazz, String alias) {
        this.replaceFields.put(field, new FieldReplace(field, clazz, alias));
        return this;
    }

    public EntityQuery<T> addLoadField(String field) {
        this.loadFields.add(field);
        return this;
    }

    public EntityQuery<T> setIgnorePopulateNull(Boolean ignorePopulateNull) {
        this.ignorePopulateNull = ignorePopulateNull;
        return this;
    }

    public EntityQuery<T> setPopulateSelect(PopulateSelect<T> populateSelect) {
        this.populateSelect = populateSelect;
        return this;
    }

    public Page<T> execute() {
        List<String> orders;
        if (this.crudRequest.getFilter() != null && !this.crudRequest.getFilter().isEmpty()) {
            EntityInfo entityInfo = this.trxManagerInfo.getEntityInfo(this.crudRequest.getType());
            this.query.append("and (1=1 ");
            for (EntityFilter filter : this.crudRequest.getFilter()) {
                this.prepareFilter(filter, entityInfo);
            }
            this.query.append(") ");
        }
        StringBuilder fields = new StringBuilder();
        if (this.selectFields != null && !this.selectFields.isEmpty()) {
            for (String subalias : this.selectFields) {
                fields.append(subalias).append(",");
            }
            fields.deleteCharAt(fields.length() - 1);
        } else {
            fields.append(this.alias);
        }
        Object groupBy = "";
        if (!this.groups.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : this.groups) {
                Iterator<Map.Entry<String, String>> fieldReplace;
                int dotidx = string.indexOf(".");
                if (dotidx != -1 && (fieldReplace = this.replaceFields.get(string.substring(0, dotidx))) != null) {
                    sb.append(string.replace(((FieldReplace)((Object)fieldReplace)).field + ".", ((FieldReplace)((Object)fieldReplace)).alias + ".")).append(",");
                    continue;
                }
                sb.append(this.alias).append(".").append(string).append(",");
            }
            if (sb.length() != 0) {
                sb.deleteCharAt(sb.length() - 1);
                groupBy = sb.toString();
                for (Map.Entry entry : this.replace.entrySet()) {
                    groupBy = ((String)groupBy).replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                groupBy = "group by " + (String)groupBy;
            }
        }
        if ((orders = this.crudRequest.getOrder()) == null || orders.isEmpty()) {
            orders = this.defaultOrders;
        }
        Object orderBy = "";
        if (!orders.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String order : orders) {
                FieldReplace fieldReplace;
                int dotidx;
                boolean asc = true;
                if (order.startsWith("-")) {
                    asc = false;
                    order = order.substring(1);
                }
                if ((dotidx = order.indexOf(".")) != -1 && (fieldReplace = this.replaceFields.get(order.substring(0, dotidx))) != null) {
                    stringBuilder.append(order.replace(fieldReplace.field + ".", fieldReplace.alias + ".")).append(asc ? " asc" : " desc").append(",");
                    continue;
                }
                stringBuilder.append(this.alias).append(".").append(order).append(asc ? " asc" : " desc").append(",");
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                orderBy = stringBuilder.toString();
                for (Map.Entry<String, String> entry : this.replace.entrySet()) {
                    orderBy = ((String)orderBy).replace(entry.getKey(), entry.getValue());
                }
                orderBy = "order by " + (String)orderBy;
            }
        }
        final String string = fields.toString();
        final String fGroupBy = ((String)groupBy).toString();
        final String fOrderBy = ((String)orderBy).toString();
        return (Page)this.trxManagerInfo.transaction(new SessionCallable<Page<T>>(){

            @Override
            public Page<T> call(Session session) throws Exception {
                return EntityQuery.this.execute0(session, string, fGroupBy, fOrderBy);
            }
        });
    }

    private Page<T> execute0(Session session, String fields, String groupBy, String orderBy) {
        Query hquery;
        Page page;
        if (this.crudRequest.getPage() != null) {
            page = Page.of(this.crudRequest.getPage().getIndex(), this.crudRequest.getPage().getSize());
            page.setCount(this.crudRequest.getPage().getCount());
        } else {
            page = Page.empty();
        }
        String hql = this.query.toString();
        if (Boolean.TRUE.equals(page.getCount())) {
            hquery = session.createQuery("select count(" + this.alias + ") " + hql + groupBy);
            for (int i = 0; i < this.parameters.size(); ++i) {
                hquery.setParameter(i + 1, this.parameters.get(i));
            }
            Long records = (Long)hquery.getSingleResult();
            page.setRecords(records);
            if (records == 0L) {
                return page;
            }
        }
        hquery = session.createQuery("select " + fields + " " + hql + groupBy + orderBy);
        for (int i = 0; i < this.parameters.size(); ++i) {
            hquery.setParameter(i + 1, this.parameters.get(i));
        }
        hquery.setFirstResult((page.getIndex() - 1) * page.getSize());
        hquery.setMaxResults(page.getSize().intValue());
        if (this.populateSelect != null) {
            ArrayList<T> data = new ArrayList<T>();
            List items = hquery.getResultList();
            if (items != null) {
                while (!items.isEmpty()) {
                    Object[] item = (Object[])items.remove(0);
                    T t = this.populateSelect.onItems(item, this.loadFields);
                    if (t == null && Boolean.TRUE.equals(this.ignorePopulateNull)) continue;
                    data.add(t);
                }
            }
            page.setData(data);
        } else {
            List data = hquery.getResultList();
            page.setData(data);
            this.trxManagerInfo.getEntityInfo(this.crudRequest.getType()).loadLazy(page, new ArrayList<String>(this.loadFields));
        }
        return page;
    }

    private void prepareFilter(EntityFilter filter, EntityInfo entityInfo) {
        FieldReplace fieldReplace;
        if (filter.getFilter() != null && !filter.getFilter().isEmpty()) {
            this.query.append(" ").append(filter.getLogical().name().toLowerCase()).append(" (1=1");
            for (EntityFilter child : filter.getFilter()) {
                this.prepareFilter(child, entityInfo);
            }
            this.query.append(")");
            return;
        }
        int dotidx = filter.getField().indexOf(".");
        if (dotidx != -1 && (fieldReplace = this.replaceFields.get(filter.getField().substring(0, dotidx))) != null) {
            String qlField = fieldReplace.alias + filter.getField().substring(dotidx);
            String field = filter.getField().substring(dotidx + 1);
            Object[] conditions = EntityHelper.condition(this.parameters.size() + 1, fieldReplace.entityInfo, qlField, filter.getCondition(), filter.getLogical(), field, filter.getValue());
            this.query.append(conditions[0]);
            if (conditions[1] != null) {
                this.parameters.add(conditions[1]);
                if (conditions[2] != null) {
                    this.parameters.add(conditions[2]);
                }
            }
            return;
        }
        Object qlField = this.alias + "." + filter.getField();
        for (Map.Entry<String, String> entry : this.replace.entrySet()) {
            qlField = ((String)qlField).replace(entry.getKey(), entry.getValue());
        }
        String field = filter.getField();
        Object[] conditions = EntityHelper.condition(this.parameters.size() + 1, entityInfo, (String)qlField, filter.getCondition(), filter.getLogical(), field, filter.getValue());
        this.query.append(conditions[0]);
        if (conditions[1] != null) {
            this.parameters.add(conditions[1]);
            if (conditions[2] != null) {
                this.parameters.add(conditions[2]);
            }
        }
    }

    private final class FieldReplace {
        private final String alias;
        private final String field;
        private final EntityInfo entityInfo;

        private FieldReplace(String field, Class<?> clazz, String alias) {
            this.field = field;
            this.entityInfo = EntityQuery.this.trxManagerInfo.getEntityInfo(clazz);
            this.alias = alias;
        }
    }

    public static interface PopulateSelect<T> {
        public T onItems(Object[] var1, Collection<String> var2);
    }
}

