/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.BeanUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class EntityTrxManagerImpl
implements EntityTrxManager,
BeanUtil.BeanConfigure<EntityTrxManager> {
    private boolean reconfigured = false;
    private Map<String, TrxManagerInfo> trxManagerInfoNames = new HashMap<String, TrxManagerInfo>();
    private Map<PlatformTransactionManager, TrxManagerInfo> trxManagerInfoManagers = new HashMap<PlatformTransactionManager, TrxManagerInfo>();
    private TrxManagerInfo defaultTrxManagerInfo;

    @Override
    public Callable<EntityTrxManager> reconfigureBean(final Collection<Object> arguments) {
        final EntityTrxManagerImpl self = this;
        return new Callable<EntityTrxManager>(){

            @Override
            public EntityTrxManager call() throws Exception {
                ApplicationContext applicationContext = (ApplicationContext)arguments.iterator().next();
                EntityTrxManagerImpl.this.trxManagerInfoNames.clear();
                EntityTrxManagerImpl.this.trxManagerInfoManagers.clear();
                Map mapContextTrxManager = applicationContext.getBeansOfType(PlatformTransactionManager.class);
                for (Map.Entry entry : mapContextTrxManager.entrySet()) {
                    TrxManagerInfo trxManagerInfo = new TrxManagerInfo((String)entry.getKey(), (PlatformTransactionManager)entry.getValue());
                    EntityTrxManagerImpl.this.trxManagerInfoNames.put((String)entry.getKey(), trxManagerInfo);
                    EntityTrxManagerImpl.this.trxManagerInfoManagers.put((PlatformTransactionManager)entry.getValue(), trxManagerInfo);
                }
                PlatformTransactionManager defaultTransactionManager = (PlatformTransactionManager)applicationContext.getBean(PlatformTransactionManager.class);
                EntityTrxManagerImpl.this.defaultTrxManagerInfo = EntityTrxManagerImpl.this.trxManagerInfoManagers.get(defaultTransactionManager);
                EntityTrxManagerImpl.this.reconfigured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    @Override
    public TrxManagerInfo getTrxManagerInfo(String name) {
        BeanUtil.checkBeanConfigure(this);
        return this.trxManagerInfoNames.get(name);
    }

    @Override
    public TrxManagerInfo getTrxManagerInfo(PlatformTransactionManager transactionManager) {
        BeanUtil.checkBeanConfigure(this);
        return this.trxManagerInfoManagers.get(transactionManager);
    }

    @Override
    public TrxManagerInfo getDefaultTrxManagerInfo() {
        BeanUtil.checkBeanConfigure(this);
        return this.defaultTrxManagerInfo;
    }

    @Override
    public Collection<TrxManagerInfo> getTrxManagerInfos() {
        BeanUtil.checkBeanConfigure(this);
        return this.trxManagerInfoManagers.values();
    }
}

