/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.mapping.Column;

public class FieldInfo {
    private static Class jsonbDateFormatClass = null;
    private static Class jsonFormatClass = null;
    @JsonIgnore
    private final EntityInfo entityInfo;
    private final Field field;
    private final String column;
    private final Method setter;
    private final Method getter;
    private final boolean lazyObject;
    private final boolean lazyCollection;
    private final Class<?> collectionGenericType;
    private final String format;
    private final Boolean nullable;
    private final Integer length;
    private final Integer scale;
    private final Integer precision;
    private final String columnDefinition;
    private final Column tableColumn;
    private Converter converter;

    public FieldInfo(EntityInfo entityInfo, Field field, String column, Column tableColumn, boolean lazyObject, boolean lazyCollection, Class<?> collectionGenericType, Boolean nullable, Integer length, Integer scale, Integer precision, String columnDefinition) {
        Class<?> modelClass = field.getDeclaringClass();
        String fieldName = field.getName();
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method setterFi = null;
        try {
            setterFi = modelClass.getMethod("set" + methodName, field.getType());
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
        Method getterFi = null;
        try {
            getterFi = modelClass.getMethod("get" + methodName, new Class[0]);
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
        String formatFi = null;
        if (jsonFormatClass != null) {
            Object jsonFormat = field.getAnnotation(jsonFormatClass);
            if (jsonFormat != null) {
                try {
                    formatFi = ((String)jsonFormatClass.getMethod("pattern", new Class[0]).invoke(jsonFormat, new Object[0])).trim();
                }
                catch (Exception e) {
                    BeanUtil.nothing();
                }
            }
        } else if (jsonbDateFormatClass != null) {
            Object jsonbDateFormat = field.getAnnotation(jsonbDateFormatClass);
            if (jsonbDateFormat != null) {
                try {
                    formatFi = ((String)jsonbDateFormatClass.getMethod("value", new Class[0]).invoke(jsonbDateFormat, new Object[0])).trim();
                }
                catch (Exception e) {
                    BeanUtil.nothing();
                }
            }
        } else {
            BeanUtil.nothing();
        }
        this.entityInfo = entityInfo;
        this.field = field;
        this.lazyObject = lazyObject;
        this.lazyCollection = lazyCollection;
        this.collectionGenericType = collectionGenericType;
        this.setter = setterFi;
        this.getter = getterFi;
        this.column = column;
        this.format = formatFi;
        this.nullable = nullable;
        this.length = length;
        this.scale = scale;
        this.precision = precision;
        this.columnDefinition = columnDefinition;
        this.tableColumn = tableColumn;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public String getColumn() {
        return this.column;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Class<?> getCollectionGenericType() {
        return this.collectionGenericType;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.field.getAnnotationsByType(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public boolean isLazyObject() {
        return this.lazyObject;
    }

    public boolean isLazyCollection() {
        return this.lazyCollection;
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public Column getTableColumn() {
        return this.tableColumn;
    }

    public void setValue(Object target, Object value) throws CommonException {
        try {
            if (this.setter != null) {
                this.setter.invoke(target, value);
            } else {
                this.field.set(target, value);
            }
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public Object getValue(Object target) throws CommonException {
        try {
            if (this.getter != null) {
                return this.getter.invoke(target, new Object[0]);
            }
            return this.field.get(target);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public Object convert(String value) {
        if (this.converter == null) {
            return null;
        }
        try {
            return this.converter.convert(Arrays.asList(value, this.format));
        }
        catch (Exception e) {
            throw BeanUtil.exception(e.getCause() != null ? e.getCause() : e);
        }
    }

    public void fieldValue(Object target, Object value) throws CommonException {
        try {
            this.field.set(target, value);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public Object fieldValue(Object target) throws CommonException {
        try {
            return this.field.get(target);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    static {
        try {
            jsonbDateFormatClass = Class.forName("javax.json.bind.annotation.JsonbDateFormat");
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
        try {
            jsonFormatClass = Class.forName("com.fasterxml.jackson.annotation.JsonFormat");
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
    }
}

