/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityListener;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.InternalPostDeleteListener;
import net.ideahut.springboot.entity.InternalPostInsertListener;
import net.ideahut.springboot.entity.InternalPostUpdateListener;
import net.ideahut.springboot.entity.InternalPreDeleteListener;
import net.ideahut.springboot.entity.InternalPreInsertListener;
import net.ideahut.springboot.entity.InternalPreUpdateListener;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.query.QueryProducer;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tuple.NonIdentifierAttribute;

final class InternalHelper {
    private InternalHelper() {
    }

    public static Map<String, Integer> getStateIndexes(Object entity, EntityPersister persister) {
        HashSet<String> names = new HashSet<String>();
        if (entity instanceof EntityAudit) {
            names.addAll(EntityAudit.Name.Field.list());
        }
        if (entity instanceof EntitySoftDelete) {
            names.add("deletedOn");
        }
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        NonIdentifierAttribute[] na = persister.getEntityMetamodel().getProperties();
        for (int i = 0; i < na.length; ++i) {
            String name = na[i].getName();
            if (!names.contains(name)) continue;
            indexes.put(name, i);
        }
        names.clear();
        names = null;
        return indexes;
    }

    public static void setStateValue(Map<String, Integer> indexes, Object[] state, String name, Object value) {
        Integer index = indexes.get(name);
        if (index != null) {
            state[index.intValue()] = value;
        }
    }

    public static void registerListeners(EntityManagerFactory entityManagerFactory) {
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)entityManagerFactory.unwrap(SessionFactoryImpl.class);
        InternalHelper.registerListeners((SessionFactoryImplementor)sessionFactory);
    }

    public static void registerListeners(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_INSERT, new InternalPreInsertListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_UPDATE, new InternalPreUpdateListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.PRE_DELETE, new InternalPreDeleteListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_INSERT, new InternalPostInsertListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_UPDATE, new InternalPostUpdateListener());
        InternalHelper.registerListener((ServiceRegistry)serviceRegistry, EventType.POST_DELETE, new InternalPostDeleteListener());
    }

    private static void registerListener(ServiceRegistry serviceRegistry, EventType eventType, Object listener) {
        EventListenerGroup group;
        EventListenerRegistry registry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        if (registry != null && (group = registry.getEventListenerGroup(eventType)) != null) {
            boolean found = false;
            for (Object object : group.listeners()) {
                if (!object.getClass().equals(listener.getClass())) continue;
                found = true;
                break;
            }
            if (!found) {
                try {
                    registry.appendListeners(eventType, new Object[]{listener});
                }
                catch (Exception e) {
                    throw BeanUtil.exception(e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] getEntityWithoutGenerator(QueryProducer session, Object entity, Object id, EntityPersister persister) throws CommonException {
        try {
            CriteriaBuilder criteriaBuilder = ((EntityManager)session).getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(entity.getClass());
            Root root = criteriaQuery.from(entity.getClass());
            ArrayList<String> ignoredFields = new ArrayList<String>();
            if (entity instanceof EntitySoftDelete) {
                ignoredFields.add("deletedOn");
            }
            if (entity instanceof EntityAudit) {
                ignoredFields.addAll(EntityAudit.Name.Field.list());
            }
            List<Field> compositeIds = EntityIntegrator.getCompositeIds(entity.getClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            StringBuilder key = new StringBuilder();
            if (compositeIds != null) {
                for (Field field : compositeIds) {
                    ignoredFields.add(field.getName());
                    predicates.add(criteriaBuilder.equal((Expression)root.get(field.getName()), field.get(entity)));
                    key.append(field.getName()).append(",");
                }
                if (key.length() == 0) throw new SQLException("id is required");
                key.deleteCharAt(key.length() - 1);
            } else {
                if (id == null) {
                    throw new SQLException("id is required");
                }
                ignoredFields.add(persister.getIdentifierPropertyName());
                key.append(persister.getIdentifierPropertyName());
                predicates.add(criteriaBuilder.equal((Expression)root.get(persister.getIdentifierPropertyName()), id));
            }
            criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
            Query query = ((Session)session).createQuery(criteriaQuery);
            Object dbEntity = query.uniqueResult();
            return new Object[]{dbEntity, ignoredFields, key};
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static final class Listener {
        private static final ThreadLocal<Boolean> skip = new InheritableThreadLocal<Boolean>();
        private static final ThreadLocal<Boolean> insert = new InheritableThreadLocal<Boolean>();
        private static final ThreadLocal<Boolean> delete = new InheritableThreadLocal<Boolean>();
        private static final ThreadLocal<Object> domain = new InheritableThreadLocal<Object>();

        private Listener() {
        }

        public static void setSkip() {
            skip.set(Boolean.TRUE);
        }

        public static boolean isSkip() {
            return Boolean.TRUE.equals(skip.get());
        }

        public static void setInsert() {
            insert.set(Boolean.TRUE);
        }

        public static boolean isInsert() {
            return Boolean.TRUE.equals(insert.get());
        }

        public static void setDelete() {
            delete.set(Boolean.TRUE);
        }

        public static boolean isDelete() {
            return Boolean.TRUE.equals(delete.get());
        }

        public static void setObject(Object object) {
            domain.set(object);
        }

        public static <T> T getObject() {
            Object object = domain.get();
            domain.remove();
            return (T)object;
        }

        public static void destroy() {
            skip.remove();
            insert.remove();
            delete.remove();
            domain.remove();
        }

        public static void onPreInsert(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = Listener.getListeners(EntityListener.PRE_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreInsert(entity);
                }
            }
            Listener.setObject(entity);
        }

        public static void onPostInsert(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = Listener.getListeners(EntityListener.POST_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostInsert(entity);
                }
            }
        }

        public static void onPreUpdate(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = Listener.getListeners(EntityListener.PRE_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreUpdate(entity);
                }
            }
            Listener.setObject(entity);
        }

        public static void onPostUpdate(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = Listener.getListeners(EntityListener.POST_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostUpdate(entity);
                }
            }
        }

        public static void onPreDelete(SessionFactory sessionFactory, Object entity) {
            List<EntityPreListener> listeners = Listener.getListeners(EntityListener.PRE_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPreListener listener : listeners) {
                    listener.onPreDelete(entity);
                }
            }
            Listener.setObject(entity);
        }

        public static void onPostDelete(SessionFactory sessionFactory, Object entity) {
            List<EntityPostListener> listeners = Listener.getListeners(EntityListener.POST_LISTENER, sessionFactory, entity);
            if (listeners != null) {
                for (EntityPostListener listener : listeners) {
                    listener.onPostDelete(entity);
                }
            }
        }

        private static <T> List<T> getListeners(String name, SessionFactory sessionFactory, Object entity) {
            RequestContext context = RequestContext.currentContext();
            List listeners = (List)context.getAttribute(name);
            if (listeners != null) {
                context.setAttribute(EntityIntegrator.SESSION_FACTORY, sessionFactory);
                T domain = Listener.getObject();
                if (entity != null && domain != null && entity instanceof EntityAudit) {
                    if (((EntityAudit)entity).getCreatedBy() == null) {
                        ((EntityAudit)entity).setCreatedBy(((EntityAudit)domain).getCreatedBy());
                    }
                    if (((EntityAudit)entity).getCreatedOn() == null) {
                        ((EntityAudit)entity).setCreatedOn(((EntityAudit)domain).getCreatedOn());
                    }
                    if (((EntityAudit)entity).getUpdatedBy() == null) {
                        ((EntityAudit)entity).setUpdatedBy(((EntityAudit)domain).getUpdatedBy());
                    }
                    if (((EntityAudit)entity).getUpdatedOn() == null) {
                        ((EntityAudit)entity).setUpdatedOn(((EntityAudit)domain).getUpdatedOn());
                    }
                }
            }
            return listeners;
        }
    }
}

