/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.query.QueryProducer;
import org.springframework.beans.BeanUtils;

class InternalPreInsertListener
implements PreInsertEventListener {
    InternalPreInsertListener() {
    }

    public boolean onPreInsert(PreInsertEvent event) {
        String actor;
        if (InternalHelper.Listener.isSkip()) {
            return true;
        }
        Object entity = event.getEntity();
        Long now = TimeUtil.currentEpochMillis();
        AuditInfo info = AuditInfo.context();
        String string = actor = info != null && info.getActor() != null ? info.getActor() : "";
        if (entity instanceof EntitySoftDelete && !EntityIntegrator.hasIdGenerator(entity.getClass())) {
            SessionImplementor session;
            block10: {
                boolean bl;
                session = null;
                try {
                    session = event.getSession().getSessionFactory().openSession();
                    Object[] objects = InternalHelper.getEntityWithoutGenerator((QueryProducer)session, event.getEntity(), event.getId(), event.getPersister());
                    Object dbEntity = objects[0];
                    List ignoredFields = (List)objects[1];
                    StringBuilder key = (StringBuilder)objects[2];
                    if (dbEntity == null) break block10;
                    if (1 != EntitySoftDelete.getDeleteStatus(dbEntity)) {
                        throw new SQLIntegrityConstraintViolationException("Duplicate entry '" + event.getId() + "' for key '" + key.toString() + "'");
                    }
                    BeanUtils.copyProperties((Object)entity, (Object)dbEntity, (String[])ignoredFields.toArray(new String[0]));
                    if (entity instanceof EntityAudit) {
                        ((EntityAudit)dbEntity).setCreatedBy(actor);
                        ((EntityAudit)dbEntity).setCreatedOn(now);
                        ((EntityAudit)dbEntity).setUpdatedBy(actor);
                        ((EntityAudit)dbEntity).setUpdatedOn(now);
                    }
                    ((EntitySoftDelete)dbEntity).setDeletedOn(null);
                    InternalHelper.Listener.onPreInsert((SessionFactory)event.getSession().getSessionFactory(), dbEntity);
                    InternalHelper.Listener.setInsert();
                    session.getTransaction().begin();
                    session.merge(dbEntity);
                    EntityHelper.commit((Session)session);
                    InternalHelper.Listener.setSkip();
                    bl = true;
                }
                catch (Exception e) {
                    try {
                        throw new ExceptionInInitializerError(e);
                    }
                    catch (Throwable throwable) {
                        EntityHelper.close(session);
                        throw throwable;
                    }
                }
                EntityHelper.close((Session)session);
                return bl;
            }
            EntityHelper.close((Session)session);
        }
        Map<String, Integer> indexes = InternalHelper.getStateIndexes(entity, event.getPersister());
        if (entity instanceof EntityAudit) {
            event.getState()[indexes.get((Object)"createdBy").intValue()] = actor;
            event.getState()[indexes.get((Object)"createdOn").intValue()] = now;
            event.getState()[indexes.get((Object)"updatedBy").intValue()] = actor;
            event.getState()[indexes.get((Object)"updatedOn").intValue()] = now;
            ((EntityAudit)entity).setCreatedBy(actor);
            ((EntityAudit)entity).setCreatedOn(now);
            ((EntityAudit)entity).setUpdatedBy(actor);
            ((EntityAudit)entity).setUpdatedOn(now);
        }
        if (entity instanceof EntitySoftDelete) {
            event.getState()[indexes.get((Object)"deletedOn").intValue()] = null;
            ((EntitySoftDelete)entity).setDeletedOn(null);
        }
        InternalHelper.Listener.onPreInsert((SessionFactory)event.getSession().getSessionFactory(), entity);
        indexes.clear();
        indexes = null;
        return false;
    }
}

