/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.Map;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.query.QueryProducer;

class InternalPreUpdateListener
implements PreUpdateEventListener {
    InternalPreUpdateListener() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onPreUpdate(PreUpdateEvent event) {
        Map<String, Integer> indexes;
        String actor;
        Long now;
        Object entity;
        block11: {
            Object[] objects;
            if (InternalHelper.Listener.isSkip()) {
                return true;
            }
            if (InternalHelper.Listener.isDelete()) {
                return false;
            }
            entity = event.getEntity();
            now = TimeUtil.currentEpochMillis();
            AuditInfo info = AuditInfo.context();
            actor = info != null && info.getActor() != null ? info.getActor() : "";
            indexes = InternalHelper.getStateIndexes(entity, event.getPersister());
            if (EntityIntegrator.hasIdGenerator(entity.getClass())) break block11;
            SessionImplementor session = null;
            try {
                session = event.getSession().getSessionFactory().openSession();
                objects = InternalHelper.getEntityWithoutGenerator((QueryProducer)session, event.getEntity(), event.getId(), event.getPersister());
            }
            catch (Exception e) {
                try {
                    throw new ExceptionInInitializerError(e);
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    throw throwable;
                }
            }
            EntityHelper.close((Session)session);
            Object dbEntity = objects[0];
            if (dbEntity == null) throw BeanUtil.exception("Entity is not found");
            if (entity instanceof EntitySoftDelete && 1 == EntitySoftDelete.getDeleteStatus(dbEntity)) {
                if (entity instanceof EntityAudit) {
                    ((EntityAudit)entity).setCreatedBy(actor);
                    ((EntityAudit)entity).setCreatedOn(now);
                    InternalHelper.setStateValue(indexes, event.getState(), "createdBy", actor);
                    InternalHelper.setStateValue(indexes, event.getState(), "createdOn", now);
                    ((EntityAudit)entity).setUpdatedBy(actor);
                    ((EntityAudit)entity).setUpdatedOn(now);
                    InternalHelper.setStateValue(indexes, event.getState(), "updatedBy", actor);
                    InternalHelper.setStateValue(indexes, event.getState(), "updatedOn", now);
                }
                ((EntitySoftDelete)entity).setDeletedOn(null);
                InternalHelper.setStateValue(indexes, event.getState(), "deletedOn", null);
                InternalHelper.Listener.setInsert();
                InternalHelper.Listener.onPreInsert((SessionFactory)event.getSession().getSessionFactory(), entity);
                return false;
            } else {
                if (dbEntity instanceof EntityAudit) {
                    ((EntityAudit)entity).setCreatedBy(((EntityAudit)dbEntity).getCreatedBy());
                    ((EntityAudit)entity).setCreatedOn(((EntityAudit)dbEntity).getCreatedOn());
                    InternalHelper.setStateValue(indexes, event.getState(), "createdBy", ((EntityAudit)dbEntity).getCreatedBy());
                    InternalHelper.setStateValue(indexes, event.getState(), "createdOn", ((EntityAudit)dbEntity).getCreatedOn());
                    ((EntityAudit)entity).setUpdatedBy(actor);
                    ((EntityAudit)entity).setUpdatedOn(now);
                    InternalHelper.setStateValue(indexes, event.getState(), "updatedBy", actor);
                    InternalHelper.setStateValue(indexes, event.getState(), "updatedOn", now);
                }
                InternalHelper.Listener.onPreUpdate((SessionFactory)event.getSession().getSessionFactory(), entity);
            }
            return false;
        }
        if (entity instanceof EntityAudit) {
            ((EntityAudit)entity).setUpdatedBy(actor);
            ((EntityAudit)entity).setUpdatedOn(now);
            InternalHelper.setStateValue(indexes, event.getState(), "updatedBy", actor);
            InternalHelper.setStateValue(indexes, event.getState(), "updatedOn", now);
        }
        InternalHelper.Listener.onPreUpdate((SessionFactory)event.getSession().getSessionFactory(), entity);
        return false;
    }
}

