/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.OptimisticLockException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.StatelessSessionCallable;
import net.ideahut.springboot.util.BeanUtil;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class TrxManagerInfo {
    private final String name;
    private final PlatformTransactionManager transactionManager;
    private final EntityIntegrator integrator;
    private final Map<Class<?>, EntityInfo> entityInfos;
    private final Map<String, EntityInfo> entityTables;

    public TrxManagerInfo(String name, PlatformTransactionManager transactionManager) throws Exception {
        this.name = name;
        this.transactionManager = transactionManager;
        this.integrator = EntityIntegrator.of(transactionManager);
        HashMap entityInfosTmi = new HashMap();
        HashMap<CallSite, EntityInfo> entityTablesTmi = new HashMap<CallSite, EntityInfo>();
        Collection<Class<?>> entityClasses = this.integrator.getAnnotatedClasses();
        for (Class<?> entityClass : entityClasses) {
            EntityInfo entityInfo = new EntityInfo(this, entityClass);
            entityInfosTmi.put(entityClass, entityInfo);
            entityTablesTmi.put((CallSite)((Object)(entityInfo.getTableSchema() + "_" + entityInfo.getTableName())), entityInfo);
        }
        this.entityInfos = Collections.unmodifiableMap(entityInfosTmi);
        this.entityTables = Collections.unmodifiableMap(entityTablesTmi);
        for (EntityInfo entityInfo : this.entityInfos.values()) {
            entityInfo.prepare();
        }
    }

    public String getName() {
        return this.name;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public EntityIntegrator getIntegrator() {
        return this.integrator;
    }

    public Set<Class<?>> getEntityClasses() {
        return this.entityInfos.keySet();
    }

    public EntityInfo getEntityInfo(Class<?> entityClass) {
        return this.entityInfos.get(entityClass);
    }

    public EntityInfo getEntityInfo(String tableSchema, String tableName) {
        tableSchema = tableSchema != null ? tableSchema : "";
        return this.entityTables.get(tableSchema + "_" + tableName);
    }

    public TrxManagerInfo loadLazy(Object object, Class<?> entityClass, Collection<String> fields) {
        EntityInfo entityInfo = this.getEntityInfo(entityClass);
        Assert.notNull((Object)entityInfo, (String)("Entity info is not found for class: " + entityClass));
        EntityHelper.loadLazy(object, entityInfo, fields);
        return this;
    }

    public TrxManagerInfo loadLazy(Object object, Collection<String> fields) {
        if (object != null) {
            this.loadLazy(object, object.getClass(), fields);
        }
        return this;
    }

    public TrxManagerInfo loadLazy(Object object, Class<?> entityClass) {
        return this.loadLazy(object, entityClass, null);
    }

    public TrxManagerInfo loadLazy(Object object) {
        if (object != null) {
            this.loadLazy(object, object.getClass(), null);
        }
        return this;
    }

    public TrxManagerInfo nullAudit(Object object) {
        if (object instanceof EntityAudit) {
            ((EntityAudit)object).setCreatedBy(null);
            ((EntityAudit)object).setCreatedOn(null);
            ((EntityAudit)object).setUpdatedBy(null);
            ((EntityAudit)object).setUpdatedOn(null);
        }
        return this;
    }

    public <T> T transaction(boolean autoCommit, SessionCallable<T> callable) {
        T t;
        Transaction transaction = null;
        SessionImplementor session = null;
        try {
            session = this.integrator.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            T result = callable.call((Session)session);
            if (autoCommit) {
                EntityHelper.commit(transaction);
            }
            t = result;
        }
        catch (Exception e) {
            block7: {
                T t2;
                try {
                    String message;
                    Throwable cause;
                    if (autoCommit && transaction != null) {
                        EntityHelper.rollback(transaction);
                    }
                    if (!((cause = e.getCause()) instanceof OptimisticLockException) || !InternalHelper.Listener.isDelete() || (message = cause.getMessage()) == null || message.indexOf("actual row count: 0; expected: 1") == -1) break block7;
                    t2 = null;
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    InternalHelper.Listener.destroy();
                    throw throwable;
                }
                EntityHelper.close((Session)session);
                InternalHelper.Listener.destroy();
                return t2;
            }
            throw BeanUtil.exception(e);
        }
        EntityHelper.close((Session)session);
        InternalHelper.Listener.destroy();
        return t;
    }

    public <T> T transaction(SessionCallable<T> callable) {
        return this.transaction(false, callable);
    }

    public <T> T transaction(boolean autoCommit, StatelessSessionCallable<T> callable) {
        T t;
        Transaction transaction = null;
        StatelessSession session = null;
        try {
            session = this.integrator.getSessionFactory().openStatelessSession();
            transaction = session.beginTransaction();
            T result = callable.call(session);
            if (autoCommit) {
                EntityHelper.commit(transaction);
            }
            t = result;
        }
        catch (Exception e) {
            block7: {
                T t2;
                try {
                    String message;
                    Throwable cause;
                    if (autoCommit && transaction != null) {
                        EntityHelper.rollback(transaction);
                    }
                    if (!((cause = e.getCause()) instanceof OptimisticLockException) || !InternalHelper.Listener.isDelete() || (message = cause.getMessage()) == null || message.indexOf("actual row count: 0; expected: 1") == -1) break block7;
                    t2 = null;
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    InternalHelper.Listener.destroy();
                    throw throwable;
                }
                EntityHelper.close(session);
                InternalHelper.Listener.destroy();
                return t2;
            }
            throw BeanUtil.exception(e);
        }
        EntityHelper.close(session);
        InternalHelper.Listener.destroy();
        return t;
    }
}

