/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class CORSFilter
extends OncePerRequestFilter {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final Set<String> ignorePaths = new HashSet<String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public CORSFilter setHeaders(Map<String, String> headers) {
        this.headers.clear();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                this.headers.put(entry.getKey(), value);
            }
        }
        return this;
    }

    public CORSFilter setIgnorePaths(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                this.ignorePaths.add(path);
            }
        }
        return this;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(HttpStatus.OK.value());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.matcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }
}

