/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.ideahut.springboot.util.BeanUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.MDC;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class MDCFilter
extends OncePerRequestFilter {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final Set<String> ignorePaths = new HashSet<String>();
    private static final int NUMRAND = 6;
    private boolean initialized = false;
    private String traceId;
    private Generator generator;

    public String getTraceId() {
        return this.traceId;
    }

    public MDCFilter setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public MDCFilter setGenerator(Generator generator) {
        this.generator = generator;
        return this;
    }

    public MDCFilter setIgnorePaths(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                this.ignorePaths.add(path);
            }
        }
        return this;
    }

    public MDCFilter initialize() {
        String string = this.traceId = this.traceId != null ? this.traceId.trim() : "";
        if (this.traceId.isEmpty()) {
            this.traceId = "traceId";
        }
        if (this.generator == null) {
            this.generator = () -> RandomStringUtils.randomAlphanumeric((int)6);
        }
        this.initialized = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.initialized();
        try {
            MDC.put((String)this.traceId, (String)this.generator.generateTraceId());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.clear();
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.matcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }

    private void initialized() {
        if (!this.initialized) {
            throw BeanUtil.exception(MDCFilter.class.getName() + " not initialized; call initialize() before using it");
        }
    }

    public static interface Generator {
        public String generateTraceId();
    }
}

