/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.ideahut.springboot.wrapper.RequestWrapper;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestWrapperFilter
extends OncePerRequestFilter {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final Set<String> ignorePaths = new HashSet<String>();

    public RequestWrapperFilter setIgnorePaths(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                this.ignorePaths.add(path);
            }
        }
        return this;
    }

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)new RequestWrapper(request), (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.matcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }
}

