/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.generator;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class Serial20DigitGenerator
implements IdentifierGenerator,
StandardGenerator {
    private static final int THOUSAND = 1000;
    private static final int THREE = 3;
    public static final String NAME = "Serial20DigitGenerator";
    public static final String STRATEGY = "net.ideahut.springboot.generator.Serial20DigitGenerator";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddHHyyyyssmmSSSMM");
    private static AtomicLong atomicLong = new AtomicLong();
    private String entityName;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.entityName = params.getProperty("entity_name");
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object id = (Serializable)session.getEntityPersister(this.entityName, object).getIdentifier(object, session);
        if (id == null || "null".equals(id)) {
            id = Serial20DigitGenerator.createSerial();
        }
        return id;
    }

    public static String createSerial() {
        String prefix = LocalDateTime.now().format(formatter);
        long number = atomicLong.getAndIncrement() % 1000L;
        String suffix = StringUtils.leftPad((String)("" + number), (int)3, (char)'0');
        return prefix + suffix;
    }
}

