/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.util.BeanUtil;

public class DataMapperImpl
implements DataMapper {
    private final TypeReference<Collection> typeRefCollection = new TypeReference<Collection>(){};
    private final TypeReference<Object[]> typeRefArray = new TypeReference<Object[]>(){};
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final XmlMapper xmlMapper;
    private AnnotationIntrospector introspector;
    private boolean includeNull = false;

    public DataMapperImpl() {
        this(false);
    }

    public DataMapperImpl(boolean includeNull) {
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.xmlMapper = new XmlMapper();
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.xmlMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.includeNull = includeNull;
        if (!includeNull) {
            this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    public AnnotationIntrospector getIntrospector() {
        return this.introspector;
    }

    public void setIntrospector(AnnotationIntrospector introspector) {
        this.introspector = introspector;
        if (introspector != null) {
            this.jsonMapper.setAnnotationIntrospector(introspector);
            this.xmlMapper.setAnnotationIntrospector(introspector);
        }
    }

    public boolean isIncludeNull() {
        return this.includeNull;
    }

    public void setIncludeNull(boolean includeNull) {
        this.includeNull = includeNull;
        if (!includeNull) {
            this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    @Override
    public <T> T read(byte[] bytes, Class<T> type, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(bytes, type);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(bytes, type);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(byte[] bytes, Class<T> type) {
        try {
            return this.read(bytes, type, 1);
        }
        catch (Exception e1) {
            return this.read(bytes, type, 2);
        }
    }

    @Override
    public <T> T read(String string, Class<T> type, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(string, type);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(string, type);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(String string, Class<T> type) {
        try {
            return this.read(string, type, 1);
        }
        catch (Exception e1) {
            return this.read(string, type, 2);
        }
    }

    @Override
    public <T> T read(InputStream stream, Class<T> type, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(stream, type);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(stream, type);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(InputStream stream, Class<T> type) {
        try {
            return this.read(stream, type, 1);
        }
        catch (Exception e1) {
            return this.read(stream, type, 2);
        }
    }

    @Override
    public <T> T read(byte[] bytes, TypeReference<T> typeRef, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(bytes, typeRef);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(bytes, typeRef);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(byte[] bytes, TypeReference<T> typeRef) {
        try {
            return this.read(bytes, typeRef, 1);
        }
        catch (Exception e1) {
            return this.read(bytes, typeRef, 2);
        }
    }

    @Override
    public <T> T read(String string, TypeReference<T> typeRef, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(string, typeRef);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(string, typeRef);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(String string, TypeReference<T> typeRef) {
        try {
            return this.read(string, typeRef, 1);
        }
        catch (Exception e1) {
            return this.read(string, typeRef, 2);
        }
    }

    @Override
    public <T> T read(InputStream stream, TypeReference<T> typeRef, int format) {
        try {
            switch (format) {
                case 1: {
                    return (T)this.jsonMapper.readValue(stream, typeRef);
                }
                case 2: {
                    return (T)this.xmlMapper.readValue(stream, typeRef);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public <T> T read(InputStream stream, TypeReference<T> typeRef) {
        try {
            return this.read(stream, typeRef, 1);
        }
        catch (Exception e1) {
            return this.read(stream, typeRef, 2);
        }
    }

    @Override
    public byte[] writeAsBytes(Object value, int format, boolean isPretty) {
        try {
            switch (format) {
                case 1: {
                    return isPretty ? this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(value) : this.jsonMapper.writeValueAsBytes(value);
                }
                case 2: {
                    return isPretty ? this.xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(value) : this.xmlMapper.writeValueAsBytes(value);
                }
            }
            return new byte[0];
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public byte[] writeAsBytes(Object value, int format) {
        return this.writeAsBytes(value, format, false);
    }

    @Override
    public String writeAsString(Object value, int format, boolean isPretty) {
        try {
            switch (format) {
                case 1: {
                    return isPretty ? this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value) : this.jsonMapper.writeValueAsString(value);
                }
                case 2: {
                    return isPretty ? this.xmlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value) : this.xmlMapper.writeValueAsString(value);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    @Override
    public String writeAsString(Object value, int format) {
        return this.writeAsString(value, format, false);
    }

    @Override
    public void writeTo(File out, Object value, int format, boolean isPretty) throws IOException {
        switch (format) {
            case 1: {
                if (isPretty) {
                    this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.jsonMapper.writeValue(out, value);
                break;
            }
            case 2: {
                if (isPretty) {
                    this.xmlMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.xmlMapper.writeValue(out, value);
                break;
            }
        }
    }

    @Override
    public void writeTo(File out, Object value, int format) throws IOException {
        this.writeTo(out, value, format, false);
    }

    @Override
    public void writeTo(OutputStream out, Object value, int format, boolean isPretty) throws IOException {
        switch (format) {
            case 1: {
                if (isPretty) {
                    this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.jsonMapper.writeValue(out, value);
                break;
            }
            case 2: {
                if (isPretty) {
                    this.xmlMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.xmlMapper.writeValue(out, value);
                break;
            }
        }
    }

    @Override
    public void writeTo(OutputStream out, Object value, int format) throws IOException {
        this.writeTo(out, value, format, false);
    }

    @Override
    public void writeTo(Writer out, Object value, int format, boolean isPretty) throws IOException {
        switch (format) {
            case 1: {
                if (isPretty) {
                    this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.jsonMapper.writeValue(out, value);
                break;
            }
            case 2: {
                if (isPretty) {
                    this.xmlMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.xmlMapper.writeValue(out, value);
                break;
            }
        }
    }

    @Override
    public void writeTo(Writer out, Object value, int format) throws IOException {
        this.writeTo(out, value, format, false);
    }

    @Override
    public void writeTo(DataOutput out, Object value, int format, boolean isPretty) throws IOException {
        switch (format) {
            case 1: {
                if (isPretty) {
                    this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.jsonMapper.writeValue(out, value);
                break;
            }
            case 2: {
                if (isPretty) {
                    this.xmlMapper.writerWithDefaultPrettyPrinter().writeValue(out, value);
                    break;
                }
                this.xmlMapper.writeValue(out, value);
                break;
            }
        }
    }

    @Override
    public void writeTo(DataOutput out, Object value, int format) throws IOException {
        this.writeTo(out, value, format, false);
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        return (T)this.jsonMapper.convertValue(value, type);
    }

    @Override
    public <T> T convert(Object value, TypeReference<T> typeRef) {
        return (T)this.jsonMapper.convertValue(value, typeRef);
    }

    @Override
    public <T> T copy(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        byte[] bytes = this.writeAsBytes(value, 1);
        return this.read(bytes, type, 1);
    }

    @Override
    public <T> T copy(Object value, TypeReference<T> typeRef) {
        T result = null;
        if (value != null) {
            byte[] bytes = this.writeAsBytes(value, 1);
            result = this.read(bytes, typeRef, 1);
        }
        return result;
    }

    @Override
    public <T> T copy(Object value) {
        Object result = null;
        if (value != null) {
            result = value instanceof Collection ? this.copy(value, this.typeRefCollection) : (value.getClass().isArray() ? this.copy(value, this.typeRefArray) : this.copy(value, value.getClass()));
        }
        return (T)result;
    }

    @Override
    public ObjectNode createObjectNode() {
        return this.jsonMapper.createObjectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this.jsonMapper.createArrayNode();
    }

    @Override
    public <T extends ObjectCodec> T mapper(int format) {
        switch (format) {
            case 1: {
                return (T)this.jsonMapper;
            }
            case 2: {
                return (T)this.xmlMapper;
            }
        }
        return null;
    }
}

