/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.message;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.util.BeanUtil;
import net.ideahut.springboot.util.RequestUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.LocaleResolver;

public class ResourceBundleMessageHandler
implements MessageHandler,
InitializingBean {
    private MessageSource messageSource;
    private LocaleResolver localeResolver;
    private List<Locale> supportedLocales;
    private Locale defaultLocale;

    public ResourceBundleMessageHandler setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        return this;
    }

    public ResourceBundleMessageHandler setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.localeResolver != null) {
            Class<?> resolverClass = this.localeResolver.getClass();
            try {
                this.supportedLocales = (List)resolverClass.getMethod("getSupportedLocales", new Class[0]).invoke((Object)this.localeResolver, new Object[0]);
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
            try {
                this.defaultLocale = (Locale)resolverClass.getMethod("getDefaultLocale", new Class[0]).invoke((Object)this.localeResolver, new Object[0]);
            }
            catch (Exception e) {
                BeanUtil.nothing();
            }
        }
    }

    @Override
    public Locale getLocale() {
        Locale locale = null;
        HttpServletRequest request = RequestUtil.getRequest();
        if (request != null) {
            locale = (Locale)request.getAttribute(LOCALE);
            if (locale == null) {
                locale = this.localeResolver.resolveLocale(request);
                request.setAttribute(LOCALE, (Object)locale);
            }
        } else {
            locale = (Locale)RequestContext.currentContext().getAttribute(LOCALE);
            if (locale == null) {
                String language;
                Locale primaryLocale = this.defaultLocale;
                if (primaryLocale == null) {
                    primaryLocale = Locale.getDefault();
                }
                locale = (language = (String)RequestContext.currentContext().getAttribute(LANGUAGE)) != null && !language.isEmpty() ? ((locale = Locale.lookup(Locale.LanguageRange.parse(language), this.supportedLocales)) != null ? locale : primaryLocale) : primaryLocale;
                RequestContext.currentContext().setAttribute(LOCALE, locale);
            }
        }
        return locale;
    }

    @Override
    public String getText(String code, boolean checkArgs, Collection<String> args) {
        Locale locale = this.getLocale();
        if (!checkArgs) {
            return this.messageSource.getMessage(code, null, locale);
        }
        if (args != null) {
            Object[] newArgs = new String[args.size()];
            int i = 0;
            for (String arg : args) {
                newArgs[i] = this.messageSource.getMessage(arg, null, locale);
                ++i;
            }
            return this.messageSource.getMessage(code, newArgs, locale);
        }
        return this.messageSource.getMessage(code, null, locale);
    }

    @Override
    public String getText(String code, Collection<String> args) {
        return this.getText(code, false, args);
    }

    @Override
    public String getText(String code) {
        return this.getText(code, false, null);
    }

    @Override
    public Message getMessage(String code, boolean checkArgs, Collection<String> args) {
        String text = this.getText(code, checkArgs, args);
        return new Message(code, text);
    }

    @Override
    public Message getMessage(String code, Collection<String> args) {
        return this.getMessage(code, false, args);
    }

    @Override
    public Message getMessage(String code) {
        return this.getMessage(code, false, null);
    }
}

