/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import net.ideahut.springboot.util.BeanUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.Tika;

public final class Multimedia
implements Serializable {
    private static final long serialVersionUID = -8204656425592317183L;
    public static final char IMAGE = 'I';
    public static final char AUDIO = 'A';
    public static final char VIDEO = 'V';
    private static final String BASE64 = "base64,";
    private static final String MIME_IMAGE = "image/";
    private static final String MIME_AUDIO = "audio/";
    private static final String MIME_VIDEO = "video/";
    private static final String[][] mapImage = new String[][]{{"vnd.microsoft.icon", "ico"}, {"svg+xml", "svg"}};
    private static final String[][] mapAudio = new String[][]{{"x-midi", "mid"}, {"midi", "mid"}, {"mpeg", "mp3"}, {"ogg", "oga"}, {"webm", "weba"}, {"3gpp", "3gp"}, {"3gpp2", "3g2"}};
    private static final String[][] mapVideo = new String[][]{{"quicktime", "mp4"}, {"x-msvideo", "avi"}, {"ogg", "ogv"}, {"mp2t", "ts"}, {"3gpp", "3gp"}, {"3gpp2", "3g2"}};
    private final byte[] bytes;
    private final String mime;
    private final String extention;
    private final char type;
    private final int size;
    private int width;
    private int height;

    private Multimedia(byte[] bytes) {
        String mextention;
        Tika tika = new Tika();
        int mtype = 0;
        String mmime = tika.detect(bytes);
        int idx = mmime.indexOf(";");
        if (idx != -1) {
            mmime = mmime.substring(0, idx);
        }
        if (mmime.startsWith(MIME_IMAGE)) {
            mtype = 73;
            mextention = Multimedia.getExtention(mmime.substring(MIME_IMAGE.length()), mapImage);
        } else if (mmime.startsWith(MIME_AUDIO)) {
            mtype = 65;
            mextention = Multimedia.getExtention(mmime.substring(MIME_AUDIO.length()), mapAudio);
        } else if (mmime.startsWith(MIME_VIDEO)) {
            mtype = 86;
            mextention = Multimedia.getExtention(mmime.substring(MIME_VIDEO.length()), mapVideo);
        } else {
            throw BeanUtil.exception("Unsupported mime type: " + mmime);
        }
        this.bytes = bytes;
        this.size = bytes.length;
        this.type = (char)mtype;
        this.mime = mmime;
        this.extention = mextention;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getMime() {
        return this.mime;
    }

    public String getExtention() {
        return this.extention;
    }

    public char getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public Multimedia setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Multimedia setHeight(int height) {
        this.height = height;
        return this;
    }

    private static String getExtention(String str, String[][] map) {
        for (String[] s : map) {
            if (str.indexOf(s[0]) == -1) continue;
            return s[1];
        }
        return str;
    }

    public static Multimedia of(byte[] bytes) {
        return new Multimedia(bytes);
    }

    public static Multimedia of(String base64String) {
        if (base64String == null) {
            return null;
        }
        String str = String.valueOf(base64String.trim());
        int idx = str.indexOf(BASE64);
        if (idx != -1) {
            str = str.substring(idx + BASE64.length());
        }
        byte[] bytes = Base64.decodeBase64((String)str);
        return new Multimedia(bytes);
    }
}

