/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -6777969103590595404L;
    public static final Integer DEFAULT_PAGE_SIZE = 20;
    private Integer index;
    private Integer size;
    private Integer total;
    private Long records;
    private transient List<T> data;
    private transient Map<String, Object> info;
    private Boolean count;

    public Page() {
        this(null, null, null);
    }

    public Page(Integer index) {
        this(index, null, null);
    }

    public Page(Integer index, Integer size) {
        this(index, size, null);
    }

    public Page(Integer index, Integer size, Boolean count) {
        this.index = index != null && index > 0 ? index : 1;
        this.size = size != null && size > 0 ? size : DEFAULT_PAGE_SIZE;
        this.count = count != null ? count : Boolean.FALSE;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Page<T> setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public Page<T> setSize(Integer size) {
        this.size = size;
        return this;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Page<T> setTotal(Integer total) {
        this.total = total;
        return this;
    }

    public Boolean getCount() {
        return this.count;
    }

    public Page<T> setCount(Boolean count) {
        this.count = count;
        return this;
    }

    public Long getRecords() {
        return this.records;
    }

    public Page<T> setRecords(Long records) {
        this.records = records;
        if (records != null && this.size > 0) {
            this.total = (int)Math.ceil((float)records.longValue() / (float)this.size.intValue());
        }
        return this;
    }

    public List<T> getData() {
        return this.data;
    }

    public Page<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public Page<T> setInfo(Map<String, Object> info) {
        this.info = info;
        return this;
    }

    public Page<T> setInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new HashMap<String, Object>();
        }
        this.info.put(key, value);
        return this;
    }

    public static <T> Page<T> of(Integer index) {
        return new Page<T>(index, null, null);
    }

    public static <T> Page<T> of(Integer index, Integer size) {
        return new Page<T>(index, size, null);
    }

    public static <T> Page<T> of(Integer index, Integer size, Boolean count) {
        return new Page<T>(index, size, count);
    }

    public static <T> Page<T> empty() {
        return new Page<T>();
    }
}

