/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.object.Message;

public final class Result
implements Serializable {
    private static final long serialVersionUID = 3635693412249849007L;
    private Long time;
    private Integer status;
    private List<Message> error;
    private transient Object data;
    private transient Map<String, Object> info;

    private Result(Integer status, Object data, List<Message> error) {
        this.status = status;
        this.data = data;
        this.error = error;
        this.time = RequestContext.time();
    }

    public Integer getStatus() {
        return this.status;
    }

    public Result setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public List<Message> getError() {
        return this.error;
    }

    public Result setError(List<Message> error) {
        this.error = error;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public Result setData(Object data) {
        this.data = data;
        return this;
    }

    public Result setInfo(Map<String, Object> info) {
        this.info = info;
        return this;
    }

    public Result setInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new HashMap<String, Object>();
        }
        this.info.put(key, value);
        return this;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public Long getTime() {
        return this.time;
    }

    public Result updateTime() {
        this.time = RequestContext.time();
        return this;
    }

    public boolean hasError() {
        return this.error != null && !this.error.isEmpty();
    }

    public static Result status(Integer status, Object data) {
        return new Result(status, data, null);
    }

    public static Result status(Integer status) {
        return new Result(status, null, null);
    }

    public static Result success(Object data) {
        return new Result(0, data, null);
    }

    public static Result success() {
        return new Result(0, null, null);
    }

    public static Result error(List<Message> error) {
        return new Result(1, null, error);
    }

    public static Result error(Message error) {
        return Result.error(Arrays.asList(error));
    }

    public static Result error(String code, String text) {
        return Result.error(new Message(code, text));
    }

    public static Result error(String code) {
        return Result.error(new Message(code, null));
    }

    public static Result error() {
        return new Result(1, null, null);
    }

    public static final class Status {
        public static final int SUCCESS = 0;
        public static final int ERROR = 1;

        private Status() {
        }
    }
}

