/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.report;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.report.ReportHandler;
import net.ideahut.springboot.report.ReportInput;
import net.ideahut.springboot.report.ReportResult;
import net.ideahut.springboot.report.ReportType;
import net.ideahut.springboot.util.BeanUtil;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;

public class ReportHandlerImpl
implements ReportHandler {
    @Override
    public ReportResult createReport(ReportInput input, boolean useExportManager) throws CommonException {
        try {
            JasperPrint print = this.createPrint(input);
            ReportType type = input.getType();
            if (useExportManager) {
                return ReportResult.of(type, switch (type) {
                    case ReportType.PDF -> JasperExportManager.exportReportToPdf((JasperPrint)print);
                    case ReportType.XML -> JasperExportManager.exportReportToXml((JasperPrint)print).getBytes();
                    default -> throw new Exception("Unsupported use export manager for type: " + type.name());
                });
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JRAbstractExporter exporter = (JRAbstractExporter)BeanUtil.newInstance(BeanUtil.classOf(type.getExporter()));
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print));
            Object output = Class.forName(type.getOutput()).getConstructor(OutputStream.class).newInstance(baos);
            if (output instanceof OutputStreamExporterOutput) {
                exporter.setExporterOutput((ExporterOutput)((OutputStreamExporterOutput)output));
            } else if (output instanceof ExporterOutput) {
                exporter.setExporterOutput((ExporterOutput)output);
            } else {
                BeanUtil.nothing();
            }
            exporter.exportReport();
            byte[] bytes = baos.toByteArray();
            return ReportResult.of(type, bytes);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    @Override
    public ReportResult createReport(ReportInput input) throws CommonException {
        return this.createReport(input, false);
    }

    @Override
    public JasperPrint createPrint(ReportInput input) throws JRException {
        Object first;
        JasperReport jReport = input.getReport();
        Object jrDataSource = null;
        Collection<?> datasource = input.getDatasource();
        jrDataSource = datasource != null && !datasource.isEmpty() ? ((first = datasource.iterator().next()) instanceof Map ? new JRMapCollectionDataSource(datasource) : (first instanceof Object[] ? new JRBeanArrayDataSource(datasource.toArray(new Object[0])) : new JRBeanCollectionDataSource(datasource))) : new JREmptyDataSource();
        return JasperFillManager.fillReport((JasperReport)jReport, input.getParameters(), (JRDataSource)jrDataSource);
    }
}

