/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.rest.RestClient;
import net.ideahut.springboot.rest.RestPair;
import net.ideahut.springboot.util.BeanUtil;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;

public enum RestMethod {
    GET(GetMethod.class),
    POST(PostMethod.class),
    PUT(PutMethod.class),
    DELETE(DeleteMethod.class),
    HEAD(HeadMethod.class),
    OPTIONS(OptionsMethod.class);

    private final Class<? extends HttpMethod> targetClass;

    private RestMethod(Class<? extends HttpMethod> targetClass) {
        this.targetClass = targetClass;
    }

    public HttpMethod newHttpMethod(String url) throws CommonException {
        return this.newHttpMethod(url, null, null);
    }

    public HttpMethod newHttpMethod(String url, Collection<RestPair> parameters) throws CommonException {
        return this.newHttpMethod(url, null, parameters);
    }

    public HttpMethod newHttpMethod(String url, byte[] entity) throws CommonException {
        return this.newHttpMethod(url, entity, null);
    }

    public HttpMethod newHttpMethod(String url, byte[] entity, Collection<RestPair> parameters) throws CommonException {
        try {
            HttpMethod method;
            Protocol protocol;
            URL u = new URL(url);
            if ("https".equals(u.getProtocol()) && ((protocol = Protocol.getProtocol((String)"https")) == null || !protocol.getSocketFactory().equals(RestClient.getDefaultSSLProtocolSocketFactory()))) {
                Protocol https = new Protocol("https", RestClient.getDefaultSSLProtocolSocketFactory(), u.getPort() != -1 ? u.getPort() : 443);
                Protocol.registerProtocol((String)"https", (Protocol)https);
            }
            if ((method = (HttpMethod)BeanUtil.newInstance(this.targetClass)) instanceof PostMethod) {
                method.setURI(new URI(url, false));
                if (parameters != null) {
                    for (RestPair parameter : parameters) {
                        ((PostMethod)method).setParameter(parameter.getName(), "" + parameter.getValue());
                    }
                }
            } else {
                StringBuilder sb = new StringBuilder();
                if (parameters != null) {
                    for (RestPair parameter : parameters) {
                        if (parameter.getValue() != null) continue;
                        sb.append(parameter.getName()).append("=").append(parameter.getValue()).append("&");
                    }
                    if (sb.length() != 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
                String curl = url + (url.indexOf("?") != -1 ? "&" : "?") + sb.toString();
                method.setURI(new URI(curl, false));
            }
            if (entity != null && method instanceof EntityEnclosingMethod) {
                ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)new ByteArrayRequestEntity(entity));
            }
            return method;
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static void setHeaders(HttpMethod method, Collection<RestPair> headers) {
        if (headers != null) {
            for (RestPair header : headers) {
                if (header == null) continue;
                method.setRequestHeader(header.getName(), "" + header.getValue());
            }
        }
    }

    public static void setCookies(HttpMethod method, String cookies) {
        if (cookies != null) {
            method.setRequestHeader("Cookie", cookies);
        }
    }

    public static void setCookies(HttpMethod method, Collection<Cookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookies) {
            sb.append(cookie.getName()).append("=").append(cookie.getValue()).append("; ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
            RestMethod.setCookies(method, sb.toString());
        }
    }

    public static void setCookies(HttpMethod method, Map<String, List<Cookie>> cookies) {
        StringBuilder sb = new StringBuilder();
        if (cookies != null) {
            for (Map.Entry<String, List<Cookie>> entry : cookies.entrySet()) {
                if (entry.getValue() == null) continue;
                for (Cookie cookie : entry.getValue()) {
                    sb.append(cookie.getName()).append("=").append(cookie.getValue()).append("; ");
                }
            }
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
            RestMethod.setCookies(method, sb.toString());
        }
    }

    public static Map<String, List<Cookie>> getCookiesMap(Collection<Cookie> cookies) {
        HashMap<String, List<Cookie>> map = new HashMap<String, List<Cookie>>();
        for (Cookie cookie : cookies) {
            if (cookie == null) continue;
            ArrayList<Cookie> list = (ArrayList<Cookie>)map.get(cookie.getName());
            if (list == null) {
                list = new ArrayList<Cookie>();
                map.put(cookie.getName(), list);
            }
            list.add(cookie);
        }
        return map;
    }

    public static Map<String, List<Cookie>> getCookiesMap(String cookies) {
        HashMap<String, List<Cookie>> map = new HashMap<String, List<Cookie>>();
        if (cookies != null) {
            String[] split;
            for (String str : split = cookies.split("; ")) {
                int idx = str.indexOf("=");
                if (idx == -1) continue;
                String name = str.substring(0, idx).trim();
                String value = str.substring(idx + 1);
                ArrayList<Cookie> list = map.getOrDefault(name, null);
                if (list == null) {
                    list = new ArrayList<Cookie>();
                    map.put(name, list);
                }
                Cookie cookie = new Cookie();
                cookie.setName(name);
                cookie.setValue(value);
                list.add(cookie);
            }
        }
        return map;
    }
}

