/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.rest.RestClient;
import net.ideahut.springboot.util.StringUtil;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;

public final class RestResponse {
    private final int status;
    private final byte[] body;
    private final Map<String, String> headers = new HashMap<String, String>();

    private RestResponse(RestClient client, HttpMethod method) throws CommonException {
        try {
            String contenEncoding;
            boolean isGzip;
            this.status = client.executeMethod(method);
            this.headers.clear();
            Header[] responseHeaders = method.getResponseHeaders();
            if (responseHeaders != null) {
                for (Header responseHeader : responseHeaders) {
                    this.headers.put(responseHeader.getName(), responseHeader.getValue());
                }
            }
            boolean bl = isGzip = (contenEncoding = this.headers.get("Content-Encoding")) != null && contenEncoding.toLowerCase().indexOf("gzip") != -1;
            if (isGzip) {
                int len;
                GZIPInputStream gzipIn = new GZIPInputStream(method.getResponseBodyAsStream());
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = gzipIn.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                gzipIn.close();
                out.flush();
                this.body = out.toByteArray();
                out.close();
            } else {
                InputStream stream = method.getResponseBodyAsStream();
                this.body = stream != null ? IOUtils.toByteArray((InputStream)stream) : new byte[0];
            }
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getHeader(String name, String defaultValue) {
        String value = this.headers.get(name);
        return value != null ? value : defaultValue;
    }

    public String getHeader(String name) {
        return this.getHeader(name, null);
    }

    public byte[] getBodyAsBytes() {
        return this.body;
    }

    public String getBodyAsString(String encoding) {
        return this.body != null ? IOUtils.toString((byte[])this.body, (String)encoding) : null;
    }

    public String getBodyAsString() {
        return this.getBodyAsString(StringUtil.CHARSET.name());
    }

    public InputStream getBodyAsStream() {
        return new ByteArrayInputStream(this.body);
    }

    public static RestResponse of(RestClient client, HttpMethod method) throws CommonException {
        return new RestResponse(client, method);
    }
}

