/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.task.TaskProperties;
import net.ideahut.springboot.task.TaskResult;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class TaskHandlerImpl
implements TaskHandler,
InitializingBean {
    private static final Integer DEFAULT_KEEP_ALIVE_SECONDS = 60;
    private ThreadPoolExecutor taskExecutor;
    private TaskProperties taskProperties;

    public TaskHandlerImpl setTaskProperties(TaskProperties taskProperties) {
        this.taskProperties = taskProperties;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskProperties == null) {
            this.taskProperties = new TaskProperties();
        }
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        Boolean allowCoreThreadTimeOut = this.taskProperties.getAllowCoreThreadTimeOut();
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut((allowCoreThreadTimeOut != null ? allowCoreThreadTimeOut : Boolean.FALSE).booleanValue());
        Integer awaitTerminationSeconds = this.taskProperties.getAwaitTerminationSeconds();
        threadPoolTaskExecutor.setAwaitTerminationSeconds(awaitTerminationSeconds != null && awaitTerminationSeconds > 0 ? awaitTerminationSeconds : 0);
        Integer corePoolSize = this.taskProperties.getCorePoolSize();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize != null && corePoolSize > 1 ? corePoolSize : 1);
        Boolean daemon = this.taskProperties.getDaemon();
        threadPoolTaskExecutor.setDaemon((daemon != null ? daemon : Boolean.FALSE).booleanValue());
        Integer keepAliveSeconds = this.taskProperties.getKeepAliveSeconds();
        threadPoolTaskExecutor.setKeepAliveSeconds((keepAliveSeconds != null && keepAliveSeconds > 0 ? keepAliveSeconds : DEFAULT_KEEP_ALIVE_SECONDS).intValue());
        Integer maxPoolSize = this.taskProperties.getMaxPoolSize();
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize != null && maxPoolSize > 0 ? maxPoolSize.intValue() : threadPoolTaskExecutor.getCorePoolSize());
        Integer queueCapacity = this.taskProperties.getQueueCapacity();
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity != null && queueCapacity > 0 ? queueCapacity : Integer.MAX_VALUE);
        String threadNamePrefix = this.taskProperties.getThreadNamePrefix();
        threadPoolTaskExecutor.setThreadNamePrefix((String)(threadNamePrefix != null && !threadNamePrefix.trim().isEmpty() ? threadNamePrefix : "TaskHandler-" + System.nanoTime() + "-"));
        Integer threadPriority = this.taskProperties.getThreadPriority();
        threadPoolTaskExecutor.setThreadPriority(threadPriority != null && threadPriority > 0 ? threadPriority : 5);
        Boolean waitForJobsToCompleteOnShutdown = this.taskProperties.getWaitForJobsToCompleteOnShutdown();
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown((waitForJobsToCompleteOnShutdown != null ? waitForJobsToCompleteOnShutdown : Boolean.FALSE).booleanValue());
        threadPoolTaskExecutor.afterPropertiesSet();
        this.taskExecutor = threadPoolTaskExecutor.getThreadPoolExecutor();
    }

    @Override
    public <T> Map<String, TaskResult<T>> submit(Map<String, Callable<T>> callables, Long timeout) {
        HashMap<String, Future<T>> tasks = new HashMap<String, Future<T>>();
        for (Map.Entry<String, Callable<T>> entry : callables.entrySet()) {
            Future<T> task = this.taskExecutor.submit(entry.getValue());
            tasks.put(entry.getKey(), task);
        }
        HashMap<String, TaskResult<T>> results = new HashMap<String, TaskResult<T>>();
        for (Map.Entry entry : tasks.entrySet()) {
            try {
                Object value = timeout != null && timeout > 0L ? ((Future)entry.getValue()).get(timeout, TimeUnit.MILLISECONDS) : ((Future)entry.getValue()).get();
                results.put((String)entry.getKey(), TaskResult.of(value));
            }
            catch (Exception e) {
                results.put((String)entry.getKey(), TaskResult.of(e));
            }
        }
        tasks.clear();
        return results;
    }

    @Override
    public <T> Map<String, TaskResult<T>> submit(Map<String, Callable<T>> callables) {
        return this.submit(callables, null);
    }

    @Override
    public <T> List<TaskResult<T>> submit(List<Callable<T>> callables, Long timeout) {
        ArrayList<Future<T>> tasks = new ArrayList<Future<T>>();
        for (Callable<T> callable : callables) {
            Future<T> task = this.taskExecutor.submit(callable);
            tasks.add(task);
        }
        ArrayList<TaskResult<T>> results = new ArrayList<TaskResult<T>>();
        while (!tasks.isEmpty()) {
            Future task = (Future)tasks.remove(0);
            try {
                Object value = timeout != null && timeout > 0L ? task.get(timeout, TimeUnit.MILLISECONDS) : task.get();
                results.add(TaskResult.of(value));
            }
            catch (Exception e) {
                results.add(TaskResult.of(e));
            }
        }
        return results;
    }

    @Override
    public <T> List<TaskResult<T>> submit(List<Callable<T>> callables) {
        return this.submit(callables, null);
    }

    @Override
    public void execute(Collection<Runnable> tasks) {
        if (tasks != null) {
            for (Runnable task : tasks) {
                this.execute(task);
            }
        }
    }

    @Override
    public void execute(Runnable task) {
        if (task != null) {
            this.taskExecutor.execute(task);
        }
    }

    public void shutdown() {
        this.taskExecutor.shutdown();
    }
}

