/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.task;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

public class TaskInput {
    private final Long timeout;
    private final TimeUnit timeUnit;
    private final Callable<?> callable;

    private TaskInput(Long timeout, TimeUnit timeUnit, Callable<?> callable) {
        Assert.notNull(callable, (String)"Callable is required");
        if (timeout != null && timeout <= 0L) {
            Assert.isTrue((boolean)false, (String)("Invalid timeout value: " + timeout));
        }
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.callable = callable;
    }

    public static TaskInput of(Long timeOut, TimeUnit timeUnit, Callable<?> callable) {
        return new TaskInput(timeOut, timeUnit, callable);
    }

    public static TaskInput of(Callable<?> callable) {
        return new TaskInput(null, null, callable);
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Callable<?> getCallable() {
        return this.callable;
    }
}

