/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.task;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.ideahut.springboot.task.TaskInput;
import net.ideahut.springboot.task.TaskProcess;
import net.ideahut.springboot.task.TaskResult;
import org.springframework.util.Assert;

public class TaskMapExecutor {
    private final ExecutorService executor;
    private final Map<Object, TaskProcess> map = new HashMap<Object, TaskProcess>();

    private TaskMapExecutor(Integer threads) {
        Assert.isTrue((threads != null && threads > 0 ? 1 : 0) != 0, (String)("Invalid num of threads: " + threads));
        this.executor = Executors.newFixedThreadPool(threads);
    }

    public static TaskMapExecutor of(Integer threads) {
        return new TaskMapExecutor(threads);
    }

    public TaskMapExecutor put(Object key, TaskInput input) {
        Assert.notNull((Object)key, (String)"key is required");
        Assert.isTrue((!this.map.containsKey(key) ? 1 : 0) != 0, (String)("Duplicate key: " + key));
        this.map.put(key, TaskProcess.of(this.executor, input));
        return this;
    }

    public TaskMapExecutor put(Object key, Callable<?> callable) {
        return this.put(key, TaskInput.of(callable));
    }

    public TaskMapExecutor put(Map<Object, TaskInput> inputs) {
        if (inputs != null) {
            for (Map.Entry<Object, TaskInput> entry : inputs.entrySet()) {
                Assert.notNull((Object)entry.getKey(), (String)"key is required");
                Assert.isTrue((!this.map.containsKey(entry.getKey()) ? 1 : 0) != 0, (String)("Duplicate key: " + entry.getKey()));
            }
            for (Map.Entry<Object, TaskInput> entry : inputs.entrySet()) {
                this.map.put(entry.getKey(), TaskProcess.of(this.executor, entry.getValue()));
            }
        }
        return this;
    }

    public void parallel(ParallelMapResult parallelMapResult) {
        Assert.isTrue((!this.executor.isShutdown() ? 1 : 0) != 0, (String)"Tasks have been processed");
        for (Map.Entry<Object, TaskProcess> entry : this.map.entrySet()) {
            TaskProcess process = entry.getValue();
            TaskInput input = process.getInput();
            Future<?> future = process.getFuture();
            if (future == null) {
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(null));
                continue;
            }
            try {
                Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(value));
            }
            catch (Exception e) {
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(e));
            }
        }
        this.executor.shutdownNow();
        this.map.clear();
    }

    public Map<Object, TaskResult<?>> parallelResult() {
        final HashMap results = new HashMap();
        this.parallel(new ParallelMapResult(){

            @Override
            public void onParallelMapResult(Object key, TaskResult<?> result) {
                results.put(key, result);
            }
        });
        return results;
    }

    public void concurrent(ConcurrentMapResult concurrentMapResult) throws Exception {
        Assert.isTrue((!this.executor.isShutdown() ? 1 : 0) != 0, (String)"Tasks have been processed");
        try {
            for (Map.Entry<Object, TaskProcess> entry : this.map.entrySet()) {
                TaskProcess process = entry.getValue();
                TaskInput input = process.getInput();
                Future<?> future = process.getFuture();
                if (future == null) {
                    if (concurrentMapResult == null) continue;
                    concurrentMapResult.onConcurrentMapResult(entry.getKey(), null);
                    continue;
                }
                Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                if (concurrentMapResult == null) continue;
                concurrentMapResult.onConcurrentMapResult(entry.getKey(), value);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.executor.shutdownNow();
            this.map.clear();
        }
    }

    public Map<Object, Object> concurrentResult() throws Exception {
        final HashMap<Object, Object> results = new HashMap<Object, Object>();
        this.concurrent(new ConcurrentMapResult(){

            @Override
            public void onConcurrentMapResult(Object key, Object value) throws Exception {
                results.put(key, value);
            }
        });
        return results;
    }

    public static interface ParallelMapResult {
        public void onParallelMapResult(Object var1, TaskResult<?> var2);
    }

    public static interface ConcurrentMapResult {
        public void onConcurrentMapResult(Object var1, Object var2) throws Exception;
    }
}

