/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.exception.CommonException;
import net.ideahut.springboot.exception.RethrowException;
import org.hibernate.HibernateException;
import org.hibernate.cfg.AvailableSettings;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public final class BeanUtil {
    private static final Map<String, Object> singletons = Collections.synchronizedMap(new HashMap());

    private BeanUtil() {
    }

    public static <T> T singleton(String name, Callable<T> callable) {
        Object bean = singletons.getOrDefault(name, null);
        if (bean != null) {
            return (T)bean;
        }
        if (callable != null) {
            try {
                bean = callable.call();
                if (bean != null) {
                    throw new CommonException("Bean is null for name: " + name);
                }
                singletons.put(name, bean);
            }
            catch (Exception e) {
                throw new RethrowException(e);
            }
        }
        return (T)bean;
    }

    public static <T> T singleton(String name) {
        return BeanUtil.singleton(name, null);
    }

    public static <T> T singleton(Class<T> clazz, Callable<T> callable) {
        return BeanUtil.singleton(clazz.getName(), callable);
    }

    public static <T> T singleton(Class<T> clazz) {
        return BeanUtil.singleton(clazz.getName(), null);
    }

    public static Map<String, Object> getHibernateProperties(Environment environment, String prefix) {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (Field field : AvailableSettings.class.getDeclaredFields()) {
                field.setAccessible(true);
                String key = String.valueOf(field.get(null));
                String value = environment.getProperty(prefix + "." + key);
                if (!key.startsWith("hibernate.") || value == null) continue;
                properties.put(key, value);
            }
            return properties;
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public static Map<String, Object> getHibernateProperties(Map<String, Object> properties) {
        try {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            for (Field field : AvailableSettings.class.getDeclaredFields()) {
                field.setAccessible(true);
                String key = String.valueOf(field.get(null));
                Object value = properties.get(key);
                if (!key.startsWith("hibernate.") || value == null) continue;
                settings.put(key, value);
            }
            return settings;
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public static void stopThread(Thread thread) {
        if (thread == null) {
            return;
        }
        try {
            Method mtd = thread.getClass().getDeclaredMethod("stop1", Throwable.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)thread, new ThreadDeath());
        }
        catch (Exception e) {
            BeanUtil.nothing();
        }
    }

    public static <T extends GenericFilterBean> FilterRegistrationBean<T> createFilterBean(Environment environment, T filter, int order, String urlPattern) {
        filter.setEnvironment(environment);
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.addUrlPatterns(new String[]{urlPattern});
        bean.setOrder(order);
        return bean;
    }

    public static Void nothing() {
        return null;
    }

    public static void checkBeanConfigure(BeanConfigure<?> bean) {
        Assert.notNull(bean, (String)"bean required");
        if (!bean.isBeanConfigured()) {
            throw new RethrowException(bean.getClass().getName() + " not reconfigured; call reconfigureBean before using it");
        }
    }

    public static <T> Class<T> classOf(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    public static <T> Class<T> classOf(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw BeanUtil.exception(e);
        }
    }

    public static RethrowException exception(Throwable e) {
        throw new RethrowException(e);
    }

    public static RethrowException exception(String text) {
        throw new RethrowException(text);
    }

    public static <T> T newInstance(Class<?> type) throws CommonException {
        try {
            return (T)type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public static interface BeanConfigure<T> {
        public Callable<T> reconfigureBean(Collection<Object> var1);

        public boolean isBeanConfigured();
    }
}

