/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class RequestUtil {
    private RequestUtil() {
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getHeader(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getHeader(name);
        if (value == null && (value = request.getHeader(name.toLowerCase())) == null) {
            value = request.getHeader(name.toUpperCase());
        }
        return value != null ? value : defaultValue;
    }

    public static String getHeader(HttpServletRequest request, String name) {
        return RequestUtil.getHeader(request, name, null);
    }

    public static String getHeader(String name, String defaultValue) {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            return null;
        }
        return RequestUtil.getHeader(request, name, defaultValue);
    }

    public static String getHeader(String name) {
        return RequestUtil.getHeader(name, null);
    }

    public static String[] getHeaders(HttpServletRequest request, String name) {
        Enumeration values = request.getHeaders(name);
        if (values == null && (values = request.getHeaders(name.toLowerCase())) == null) {
            values = request.getHeaders(name.toUpperCase());
        }
        return values != null ? Collections.list(values).toArray(new String[0]) : null;
    }

    public static String[] getHeaders(String name) {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            return new String[0];
        }
        return RequestUtil.getHeaders(request, name);
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String host = RequestUtil.getHeader(request, "X-Forwarded-For", "").trim();
        if (host.isEmpty()) {
            host = request.getRemoteAddr();
        }
        host = host.split("\\,")[0].trim();
        return host;
    }

    public static String getRemoteHost() {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            return "";
        }
        return RequestUtil.getRemoteHost(request);
    }

    public static String getUserAgent(HttpServletRequest request) {
        return RequestUtil.getHeader(request, "User-Agent", "");
    }

    public static String getUserAgent() {
        HttpServletRequest request = RequestUtil.getRequest();
        if (request == null) {
            return "";
        }
        return RequestUtil.getUserAgent(request);
    }
}

