/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import net.ideahut.springboot.util.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.env.PropertyResolver;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;

public final class WebUtil {
    private static final String PARAMETER_ENCRYPT = "_enc_";

    private WebUtil() {
    }

    public static String encodeText(String text) {
        String str = text != null ? String.valueOf(text) : "";
        String key = String.valueOf(System.nanoTime());
        return key + "$" + Base64.encodeBase64URLSafeString((byte[])(key + str).getBytes(StringUtil.CHARSET));
    }

    public static String decodeText(String text) {
        int i;
        String res = "";
        if (text != null && (i = text.indexOf("$")) != -1) {
            String key = text.substring(0, i);
            res = text.substring(i + 1);
            if (!(res = new String(Base64.decodeBase64((String)res), StringUtil.CHARSET)).startsWith(key)) {
                return null;
            }
            res = res.substring(key.length());
        }
        return res;
    }

    public static String encodeUrlQuery(String url, boolean useEncryptParam, String query) {
        String mUrl = String.valueOf(url);
        Object mQuery = "";
        int i = mUrl.indexOf("?");
        if (i != -1) {
            mQuery = mUrl.substring(i + 1, mUrl.length());
            mUrl = mUrl.substring(0, i);
        }
        if (query != null && !query.isEmpty()) {
            mQuery = (String)mQuery + (!((String)mQuery).isEmpty() ? "&" : "") + query;
        }
        if (((String)mQuery).isEmpty()) {
            return mUrl;
        }
        String enc = WebUtil.encodeText((String)mQuery);
        return mUrl + "?" + (useEncryptParam ? "_enc_=" : "") + enc;
    }

    public static String encodeUrlQuery(String url, String query) {
        return WebUtil.encodeUrlQuery(url, true, query);
    }

    public static String encodeUrlParameters(String url, boolean useEncryptParam, Map<String, String> parameters) {
        StringBuilder query = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                String value = parameters.get(key);
                if (value == null) continue;
                query.append(key).append("=").append(value).append("&");
            }
            if (query.length() != 0) {
                query.deleteCharAt(query.length() - 1);
            }
        }
        return WebUtil.encodeUrlQuery(url, useEncryptParam, query.toString());
    }

    public static String encodeUrlParameters(String url, Map<String, String> parameters) {
        return WebUtil.encodeUrlParameters(url, true, parameters);
    }

    public static String encodeUrl(String url, boolean useEncryptParam, Collection<String> parameters) {
        StringBuilder query = new StringBuilder();
        for (String p : parameters) {
            query.append(p).append("&");
        }
        if (query.length() != 0) {
            query.deleteCharAt(query.length() - 1);
        }
        return WebUtil.encodeUrlQuery(url, useEncryptParam, query.toString());
    }

    public static String encodeUrl(String url, Collection<String> parameters) {
        return WebUtil.encodeUrl(url, true, parameters);
    }

    public static String encodeQuery(String query) {
        return WebUtil.encodeText(query);
    }

    public static String encodeParameters(Map<String, String> parameters) {
        StringBuilder query = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                String value = parameters.get(key);
                if (value == null) continue;
                query.append(key).append("=").append(value).append("&");
            }
            if (query.length() != 0) {
                query.deleteCharAt(query.length() - 1);
            }
        }
        return WebUtil.encodeText(query.toString());
    }

    public static Map<String, String> decodeParameters(HttpServletRequest request) {
        String txt;
        boolean useEncryptParam;
        String enc = request.getParameter(PARAMETER_ENCRYPT);
        boolean bl = useEncryptParam = enc != null;
        if (!useEncryptParam) {
            enc = request.getQueryString();
        }
        if ((txt = WebUtil.decodeText(enc)) == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> result = StringUtil.parseToMap(txt, "&", "=");
        if (useEncryptParam) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (PARAMETER_ENCRYPT.equals(name) || result.get(name) != null) continue;
                result.put(name, request.getParameter(name));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static ApiInfo swaggerApiInfo(PropertyResolver env) {
        return new ApiInfoBuilder().title(env.getProperty("swagger.info.title", "").trim()).license(env.getProperty("swagger.info.license", "").trim()).licenseUrl(env.getProperty("swagger.info.licenseUrl", "").trim()).termsOfServiceUrl(env.getProperty("swagger.info.termsOfServiceUrl", "").trim()).description(env.getProperty("swagger.info.description", "").trim()).version(env.getProperty("swagger.info.version", "").trim()).build();
    }

    public static String swaggerPackage(PropertyResolver env) {
        return env.getProperty("swagger.package", "").trim();
    }
}

