/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.AdminTrxManagerInfo;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityReplica;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.grid.GridTool;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

final class HelperEntity {
    private static final Logger log = LoggerFactory.getLogger(HelperEntity.class);
    private static final List<Class<?>> mapValueClasses = Arrays.asList(String.class, Number.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    private HelperEntity() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getDatabaseMetadata(EntityIntegrator integrator) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Connection connection = null;
        try {
            DatabaseMetaData metadata = integrator.getConnection().getMetaData();
            for (Method method : metadata.getClass().getDeclaredMethods()) {
                method.setAccessible(true);
                if (!method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
                Object value = method.invoke((Object)metadata, new Object[0]);
                map.put(method.getName().substring(3), value);
            }
        }
        catch (Exception e) {
            log.warn("DatabaseMetadata", (Object)e.getMessage());
        }
        finally {
            EntityHelper.close(connection);
        }
        return map;
    }

    private static void fixMapInfo(Map<String, Object> map) {
        if (map != null) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>(map.keySet());
            for (String key : keys) {
                Object value = map.get(key);
                if (value == null) {
                    map.remove(key);
                    continue;
                }
                value = HelperEntity.fixMapValue(value);
                map.put(key, value);
            }
        }
    }

    private static Object fixMapValue(Object value) {
        Class<?> type = value.getClass();
        for (Class<?> mapValueClass : mapValueClasses) {
            if (!mapValueClass.isAssignableFrom(type)) continue;
            return value;
        }
        return value.toString();
    }

    private static AdminTrxManagerInfo.Field createField(FieldInfo info) {
        AdminTrxManagerInfo.Field field = new AdminTrxManagerInfo.Field();
        field.setColumn(info.getColumn() != null ? info.getColumn().getName() : null);
        field.setFormat(info.getFormat());
        field.setIsEager(Boolean.valueOf(info.isEagerObject()));
        field.setIsEntity(Boolean.valueOf(Converter.isEntity(info.getConverter())));
        field.setIsEnum(Boolean.valueOf(Converter.isEnum(info.getConverter())));
        field.setIsLazy(Boolean.valueOf(info.isLazyObject() || info.isLazyCollection()));
        field.setIsLob(Boolean.valueOf(info.isLob()));
        field.setLength(info.getLength());
        field.setName(info.getName());
        field.setPrecision(info.getPrecision());
        field.setScale(info.getScale());
        field.setType(info.getType());
        return field;
    }

    private static Map<Class<?>, AdminTrxManagerInfo.Entity> getEntities(TrxManagerInfo trxManagerInfo) {
        LinkedHashMap entities = new LinkedHashMap();
        for (Class<?> eclass : trxManagerInfo.getEntityClasses()) {
            AdminTrxManagerInfo.Field field;
            EntityInfo einfo = trxManagerInfo.getEntityInfo(eclass);
            IdInfo idInfo = einfo.getIdInfo();
            AdminTrxManagerInfo.Id id = new AdminTrxManagerInfo.Id();
            id.setType(idInfo.getIdType());
            id.setFields(new ArrayList());
            if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                for (String fname2 : idInfo.getFields()) {
                    FieldInfo finfo = einfo.getFieldInfo(fname2);
                    AdminTrxManagerInfo.Field field2 = HelperEntity.createField(finfo);
                    id.getFields().add(field2);
                }
            } else if (EntityIdType.STANDARD == idInfo.getIdType()) {
                fname = idInfo.getFields().iterator().next();
                id.setName(fname);
                finfo = einfo.getFieldInfo(fname);
                AdminTrxManagerInfo.Field field3 = HelperEntity.createField(finfo);
                id.getFields().add(field3);
            } else if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
                fname = idInfo.getFields().iterator().next();
                id.setName(fname);
                finfo = einfo.getFieldInfo(fname);
                AttributeOverrides attributeOverrides = finfo.getAttributeOverrides();
                for (String column : attributeOverrides.getColums()) {
                    FieldInfo ainfo = attributeOverrides.getFieldInfo(column);
                    field = HelperEntity.createField(ainfo);
                    field.setColumn(column);
                    id.getFields().add(field);
                }
            }
            ArrayList<AdminTrxManagerInfo.Field> fields = new ArrayList<AdminTrxManagerInfo.Field>();
            LinkedHashSet<String> fnames = new LinkedHashSet<String>(einfo.getFieldInfoNames());
            fnames.removeAll(idInfo.getFields());
            for (String string : fnames) {
                FieldInfo finfo = einfo.getFieldInfo(string);
                AdminTrxManagerInfo.Field field4 = HelperEntity.createField(finfo);
                fields.add(field4);
            }
            ArrayList<AdminTrxManagerInfo.Field> transients = new ArrayList<AdminTrxManagerInfo.Field>();
            for (String fname4 : einfo.getFieldTransientNames()) {
                FieldInfo finfo = einfo.getFieldTransient(fname4);
                field = HelperEntity.createField(finfo);
                transients.add(field);
            }
            AdminTrxManagerInfo.Entity entity = new AdminTrxManagerInfo.Entity();
            entity.setFields(fields);
            entity.setHasAuditMark(Boolean.valueOf(einfo.getAnnotation(Audit.class) != null));
            entity.setId(id);
            entity.setIsAudit(Boolean.valueOf(EntityAudit.class.isAssignableFrom(einfo.getEntityClass())));
            entity.setIsSoftDelete(Boolean.valueOf(EntitySoftDelete.class.isAssignableFrom(einfo.getEntityClass())));
            entity.setTable(einfo.getTable() != null ? einfo.getTable().getName() : null);
            entity.setTransients(transients);
            entity.setType(einfo.getEntityClass());
            entities.put(entity.getType(), entity);
        }
        return entities;
    }

    private static void orderEntities(List<AdminTrxManagerInfo.Entity> entities, String order) {
        String sortby;
        String string = sortby = order != null ? new String(order.trim()) : "";
        if (!sortby.isEmpty()) {
            final boolean descending = sortby.startsWith("-");
            if (descending) {
                sortby = sortby.substring(1);
            }
            if ("type".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getType().getName().compareTo(o1.getType().getName()) : o1.getType().getName().compareTo(o2.getType().getName());
                    }
                });
            } else if ("isSoftDelete".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getIsSoftDelete().compareTo(o1.getIsSoftDelete()) : o1.getIsSoftDelete().compareTo(o2.getIsSoftDelete());
                    }
                });
            } else if ("isAudit".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getIsAudit().compareTo(o1.getIsAudit()) : o1.getIsAudit().compareTo(o2.getIsAudit());
                    }
                });
            } else if ("hasAuditMark".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getHasAuditMark().compareTo(o1.getHasAuditMark()) : o1.getHasAuditMark().compareTo(o2.getHasAuditMark());
                    }
                });
            } else if ("table".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getTable().compareTo(o1.getTable()) : o1.getTable().compareTo(o2.getTable());
                    }
                });
            } else if ("id".equals(sortby)) {
                Collections.sort(entities, new Comparator<AdminTrxManagerInfo.Entity>(){

                    @Override
                    public int compare(AdminTrxManagerInfo.Entity o1, AdminTrxManagerInfo.Entity o2) {
                        return descending ? o2.getId().getType().name().compareTo(o1.getId().getType().name()) : o1.getId().getType().name().compareTo(o2.getId().getType().name());
                    }
                });
            }
        }
    }

    protected static Map<String, AdminTrxManagerInfo> getTrxManagerInfos(ApplicationContext applicationContext) {
        EntityTrxManager entityTrxManager = null;
        try {
            entityTrxManager = (EntityTrxManager)applicationContext.getBean(EntityTrxManager.class);
        }
        catch (Exception e) {
            log.warn("TrxManagerInfos", (Object)e.getMessage());
        }
        if (entityTrxManager != null) {
            LinkedHashMap<String, AdminTrxManagerInfo> mgrInfos = new LinkedHashMap<String, AdminTrxManagerInfo>();
            for (TrxManagerInfo trxManagerInfo : entityTrxManager.getTrxManagerInfos()) {
                EntityIntegrator integrator = trxManagerInfo.getIntegrator();
                Map<String, Object> metadata = HelperEntity.getDatabaseMetadata(integrator);
                LinkedHashMap<String, Object> setting = new LinkedHashMap<String, Object>(integrator.getSettings());
                HelperEntity.fixMapInfo(metadata);
                HelperEntity.fixMapInfo(setting);
                Map<Class<?>, AdminTrxManagerInfo.Entity> entities = HelperEntity.getEntities(trxManagerInfo);
                AdminTrxManagerInfo mgrInfo = new AdminTrxManagerInfo();
                mgrInfo.setName(trxManagerInfo.getName());
                mgrInfo.setMetadata(metadata);
                mgrInfo.setSetting(setting);
                mgrInfo.setEntities(entities);
                mgrInfos.put(mgrInfo.getName(), mgrInfo);
            }
            return mgrInfos;
        }
        return null;
    }

    protected static AdminTrxManagerInfo managerInfo(DataMapper dataMapper, Map<String, AdminTrxManagerInfo> trxManagerInfos, String managerName) {
        AdminTrxManagerInfo manager = trxManagerInfos != null ? trxManagerInfos.get(managerName) : null;
        Assert.notNull((Object)manager, (String)("TrxManagerInfo is not found: " + managerName));
        AdminTrxManagerInfo info = dataMapper.copy((Object)manager, AdminTrxManagerInfo.class);
        info.setEntities(null);
        return info;
    }

    protected static Page managerEntities(Map<String, AdminTrxManagerInfo> trxManagerInfos, String managerName, Integer index, Integer size, String order) {
        AdminTrxManagerInfo manager = trxManagerInfos != null ? trxManagerInfos.get(managerName) : null;
        Assert.notNull((Object)manager, (String)("TrxManagerInfo is not found: " + managerName));
        index = index != null && index > 0 ? index : 1;
        size = size != null && size > 0 ? size : 10;
        Page page = Page.of((Integer)index, (Integer)size);
        ArrayList<AdminTrxManagerInfo.Entity> entities = new ArrayList<AdminTrxManagerInfo.Entity>(manager.getEntities().values());
        if (entities != null && !entities.isEmpty()) {
            int max;
            HelperEntity.orderEntities(entities, order);
            int records = entities.size();
            int min = (index - 1) * size;
            if (min > records - 1) {
                if (index > 1) {
                    index = index - 1;
                }
                min = (index - 1) * size;
                page.setIndex(index);
            }
            if ((max = min + size) > records) {
                max = records;
            }
            page.setRecords(Long.valueOf(records));
            page.setData(entities.subList(min, max));
        }
        return page;
    }

    protected static AdminTrxManagerInfo.Entity managerEntity(Map<String, AdminTrxManagerInfo> trxManagerInfos, String managerName, String entityClass) {
        AdminTrxManagerInfo manager = trxManagerInfos != null ? trxManagerInfos.get(managerName) : null;
        Assert.notNull((Object)manager, (String)("TrxManagerInfo is not found: " + managerName));
        Class clazz = FrameworkUtil.classOf(entityClass);
        AdminTrxManagerInfo.Entity entity = (AdminTrxManagerInfo.Entity)manager.getEntities().get(clazz);
        return entity;
    }

    protected static List<String> entityReplica(ApplicationContext applicationContext, String managerName, String entityClass, Integer numReplica) {
        EntityTrxManager entityTrxManager = (EntityTrxManager)applicationContext.getBean(EntityTrxManager.class);
        TrxManagerInfo trxManagerInfo = entityTrxManager.getTrxManagerInfo(managerName);
        Assert.notNull((Object)trxManagerInfo, (String)("TrxManagerInfo is not found: " + managerName));
        Class clazz = FrameworkUtil.classOf(entityClass);
        EntityInfo entityInfo = trxManagerInfo.getEntityInfo(clazz);
        return EntityReplica.getSQL(entityInfo, numReplica, new EntityInfo[0]);
    }

    protected static String entityGrid(ApplicationContext applicationContext, String managerName, String entityClass) throws Exception {
        EntityTrxManager entityTrxManager = (EntityTrxManager)applicationContext.getBean(EntityTrxManager.class);
        TrxManagerInfo trxManagerInfo = entityTrxManager.getTrxManagerInfo(managerName);
        Assert.notNull((Object)trxManagerInfo, (String)("TrxManagerInfo is not found: " + managerName));
        Class clazz = FrameworkUtil.classOf(entityClass);
        EntityInfo entityInfo = trxManagerInfo.getEntityInfo(clazz);
        return GridTool.generate(entityInfo, 4);
    }

    protected static AdminMenu getMenu(DataMapper dataMapper, Map<String, AdminTrxManagerInfo> trxManagerInfos, AdminProperties.Module module) {
        if (trxManagerInfos != null && !trxManagerInfos.isEmpty()) {
            String prefix = "trxManager";
            AdminMenu mroot = new AdminMenu();
            mroot.setId(prefix);
            mroot.setLink("");
            mroot.setTitle("Entity");
            if (!HelperMenu.isMenuEnable(mroot, module)) {
                return null;
            }
            String path = new String(mroot.getLink());
            if (path.isEmpty()) {
                path = "/entity";
            }
            mroot.setLink("");
            AdminMenu proot = dataMapper.copy((Object)mroot, AdminMenu.class);
            mroot.setChildren(new ArrayList());
            int i = 0;
            for (Map.Entry<String, AdminTrxManagerInfo> entry : trxManagerInfos.entrySet()) {
                AdminMenu mmenu = new AdminMenu();
                mmenu.setId(prefix + "_" + i);
                mmenu.setLink(path + "?manager=" + entry.getKey());
                mmenu.setTitle(entry.getKey().substring(0, 1).toUpperCase() + entry.getKey().substring(1));
                mmenu.setParent(proot);
                mroot.getChildren().add(mmenu);
                ++i;
            }
            return mroot;
        }
        return null;
    }
}

