/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.cache;

class MemoryCacheStore<V> {
    private static final int MILLIS = 1000;
    private V value;
    private Long expiredOn;

    public MemoryCacheStore(V value, Integer expiry) {
        this.value = value;
        this.expiredOn = MemoryCacheStore.getExpiry(expiry);
    }

    public MemoryCacheStore(V value) {
        this(value, 0);
    }

    public boolean isExpired() {
        if (this.expiredOn == 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.expiredOn;
    }

    public MemoryCacheStore<V> setExpiry(Integer expiry) {
        this.expiredOn = MemoryCacheStore.getExpiry(expiry);
        return this;
    }

    public V getValue() {
        return this.value;
    }

    public static Long getExpiry(Integer expiry) {
        if (expiry != null && expiry > 0) {
            return System.currentTimeMillis() + (long)(expiry * 1000);
        }
        return 0L;
    }
}

