/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.math.BigDecimal;
import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NumericJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class BigDecimalConverter
extends Converter {
    private static final BasicType<BigDecimal> TYPE = new BasicTypeImpl((JavaType)BigDecimalJavaType.INSTANCE, (JdbcType)NumericJdbcType.INSTANCE);

    protected BigDecimalConverter() {
    }

    private BigDecimalConverter(Class<?> type, Object ... args) {
        super(type, args);
        BigDecimalConverter.isEqual(BigDecimal.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? new BigDecimal(input) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return BigDecimal.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new BigDecimalConverter(type, args);
    }
}

