/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.CharJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class CharacterConverter
extends Converter {
    private static final BasicType<Character> TYPE = new BasicTypeImpl((JavaType)CharacterJavaType.INSTANCE, (JdbcType)CharJdbcType.INSTANCE);

    protected CharacterConverter() {
    }

    private CharacterConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        CharacterConverter.isEqual(Character.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = "" + value;
        return !input.isEmpty() ? Character.valueOf(input.charAt(0)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Character.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new CharacterConverter(type, args);
    }
}

