/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import jakarta.persistence.EnumType;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.springframework.util.Assert;

final class EnumConverter
extends Converter {
    private static final BasicType<String> STRING_TYPE = new BasicTypeImpl((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE);
    private static final BasicType<Integer> ORDINAL_TYPE = new BasicTypeImpl((JavaType)IntegerJavaType.INSTANCE, (JdbcType)IntegerJdbcType.INSTANCE);
    private Map<String, Enum<?>> names = new LinkedHashMap();
    private Type hibernateType;

    protected EnumConverter() {
    }

    private EnumConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        EnumConverter.isEqual(Enum.class, type);
        EnumType enumType = null;
        if (args != null && args.length > 1 && args[1] instanceof EnumType) {
            enumType = (EnumType)args[1];
        }
        this.hibernateType = EnumType.STRING.equals(enumType) ? STRING_TYPE : ORDINAL_TYPE;
        this.names.clear();
        try {
            Enum[] values;
            for (Enum value : values = (Enum[])type.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                String name = (String)value.getClass().getMethod("name", new Class[0]).invoke((Object)value, new Object[0]);
                this.names.put(name, value);
            }
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    @Override
    protected Object valueOf(Object value) {
        String input = "" + value;
        if (input.isEmpty()) {
            return this.nullValue();
        }
        Enum<?> eulav = this.names.get(input);
        Assert.notNull(eulav, (String)("Invalid enum " + super.getType().getName() + ": " + input));
        return eulav;
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Enum.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return this.hibernateType;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new EnumConverter(type, args);
    }
}

