/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.converter.BigDecimalConverter;
import net.ideahut.springboot.converter.BigIntegerConverter;
import net.ideahut.springboot.converter.BooleanConverter;
import net.ideahut.springboot.converter.ByteArrayConverter;
import net.ideahut.springboot.converter.ByteConverter;
import net.ideahut.springboot.converter.CharacterConverter;
import net.ideahut.springboot.converter.CollectionConverter;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.DateConverter;
import net.ideahut.springboot.converter.DoubleConverter;
import net.ideahut.springboot.converter.EntityConverter;
import net.ideahut.springboot.converter.EnumConverter;
import net.ideahut.springboot.converter.FloatConverter;
import net.ideahut.springboot.converter.IntegerConverter;
import net.ideahut.springboot.converter.LocalDateConverter;
import net.ideahut.springboot.converter.LocalDateTimeConverter;
import net.ideahut.springboot.converter.LocalTimeConverter;
import net.ideahut.springboot.converter.LongConverter;
import net.ideahut.springboot.converter.PrimitiveBooleanConverter;
import net.ideahut.springboot.converter.PrimitiveByteArrayConverter;
import net.ideahut.springboot.converter.PrimitiveByteConverter;
import net.ideahut.springboot.converter.PrimitiveCharacterConverter;
import net.ideahut.springboot.converter.PrimitiveDoubleConverter;
import net.ideahut.springboot.converter.PrimitiveFloatConverter;
import net.ideahut.springboot.converter.PrimitiveIntegerConverter;
import net.ideahut.springboot.converter.PrimitiveLongConverter;
import net.ideahut.springboot.converter.PrimitiveShortConverter;
import net.ideahut.springboot.converter.ShortConverter;
import net.ideahut.springboot.converter.StringConverter;
import net.ideahut.springboot.converter.UUIDConverter;

final class Helper {
    private static final List<Converter> converters = new ArrayList<Converter>();

    private Helper() {
    }

    protected static Converter getConverter(Class<?> type, Object ... args) {
        try {
            for (Converter converter : converters) {
                if (!converter.isSupported(type)) continue;
                return converter.newInstance(type, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        converters.add(new BigDecimalConverter());
        converters.add(new BigIntegerConverter());
        converters.add(new BooleanConverter());
        converters.add(new ByteArrayConverter());
        converters.add(new ByteConverter());
        converters.add(new CharacterConverter());
        converters.add(new CollectionConverter());
        converters.add(new DateConverter());
        converters.add(new DoubleConverter());
        converters.add(new EntityConverter());
        converters.add(new EnumConverter());
        converters.add(new FloatConverter());
        converters.add(new IntegerConverter());
        converters.add(new LocalDateConverter());
        converters.add(new LocalDateTimeConverter());
        converters.add(new LocalTimeConverter());
        converters.add(new LongConverter());
        converters.add(new PrimitiveBooleanConverter());
        converters.add(new PrimitiveByteArrayConverter());
        converters.add(new PrimitiveByteConverter());
        converters.add(new PrimitiveCharacterConverter());
        converters.add(new PrimitiveDoubleConverter());
        converters.add(new PrimitiveFloatConverter());
        converters.add(new PrimitiveIntegerConverter());
        converters.add(new PrimitiveLongConverter());
        converters.add(new PrimitiveShortConverter());
        converters.add(new ShortConverter());
        converters.add(new StringConverter());
        converters.add(new UUIDConverter());
    }

    protected static class Formatter {
        protected Formatter() {
        }

        protected static SimpleDateFormat getSimpleDateFormat(String pattern) {
            SimpleDateFormat formatter;
            String name = Helper.class.getName() + "::SimpleDateFormat";
            RequestContext context = RequestContext.currentContext();
            HashMap<String, SimpleDateFormat> map = (HashMap<String, SimpleDateFormat>)context.getAttribute(name);
            if (map == null) {
                map = new HashMap<String, SimpleDateFormat>();
                context.setAttribute(name, map);
            }
            if ((formatter = (SimpleDateFormat)map.get(pattern)) == null) {
                formatter = new SimpleDateFormat(pattern);
                map.put(pattern, formatter);
            }
            return formatter;
        }
    }
}

