/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import net.ideahut.springboot.converter.Converter;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.IntegerJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class IntegerConverter
extends Converter {
    private static final BasicType<Integer> TYPE = new BasicTypeImpl((JavaType)IntegerJavaType.INSTANCE, (JdbcType)IntegerJdbcType.INSTANCE);

    protected IntegerConverter() {
    }

    private IntegerConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        IntegerConverter.isEqual(Integer.class, type);
    }

    @Override
    protected Object valueOf(Object value) {
        String input = ("" + value).trim();
        return !input.isEmpty() ? Integer.valueOf(Integer.parseInt(input)) : this.nullValue();
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return Integer.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new IntegerConverter(type, args);
    }
}

