/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.Helper;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LocalDateTimeJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class LocalDateTimeConverter
extends Converter {
    private static final BasicType<LocalDateTime> TYPE = new BasicTypeImpl((JavaType)LocalDateTimeJavaType.INSTANCE, (JdbcType)TimestampJdbcType.INSTANCE);
    private String pattern;
    private DateTimeFormatter formatter;

    protected LocalDateTimeConverter() {
    }

    private LocalDateTimeConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        LocalDateTimeConverter.isEqual(LocalDateTime.class, type);
        this.pattern = "";
        if (args != null && args.length > 0 && args[0] instanceof String) {
            this.pattern = ((String)args[0]).trim();
        }
        if (this.pattern.isEmpty()) {
            this.pattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
        }
        this.formatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    @Override
    protected Object valueOf(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            return LocalDateTime.parse(Helper.Formatter.getSimpleDateFormat(this.pattern).format(date), this.formatter);
        }
        String input = "" + value;
        if (input.isEmpty()) {
            return this.nullValue();
        }
        return LocalDateTime.parse(input, this.formatter);
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return LocalDateTime.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new LocalDateTimeConverter(type, args);
    }
}

