/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.converter.Helper;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LocalTimeJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TimeJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;

final class LocalTimeConverter
extends Converter {
    private static final BasicType<LocalTime> TYPE = new BasicTypeImpl((JavaType)LocalTimeJavaType.INSTANCE, (JdbcType)TimeJdbcType.INSTANCE);
    private String pattern;
    private DateTimeFormatter formatter;

    protected LocalTimeConverter() {
    }

    private LocalTimeConverter(Class<?> type, Object ... args) {
        super(type, new Object[0]);
        LocalTimeConverter.isEqual(LocalTime.class, type);
        this.pattern = "";
        if (args != null && args.length > 0 && args[0] instanceof String) {
            this.pattern = ((String)args[0]).trim();
        }
        if (this.pattern.isEmpty()) {
            this.pattern = "HH:mm:ss";
        }
        this.formatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    @Override
    protected Object valueOf(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            return LocalTime.parse(Helper.Formatter.getSimpleDateFormat(this.pattern).format(date), this.formatter);
        }
        String input = "" + value;
        if (input.isEmpty()) {
            return this.nullValue();
        }
        return LocalTime.parse(input, this.formatter);
    }

    @Override
    protected boolean isSupported(Class<?> type) {
        return LocalTime.class.isAssignableFrom(type);
    }

    @Override
    public Type getHibernateType() {
        return TYPE;
    }

    @Override
    protected Object nullValue() {
        return null;
    }

    @Override
    protected Converter newInstance(Class<?> type, Object ... args) {
        return new LocalTimeConverter(type, args);
    }
}

