/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudConstant;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudPermission;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.init.InitMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CrudHandlerImpl
implements CrudHandler,
InitializingBean,
InitMapper {
    private EntityTrxManager entityTrxManager;
    private CrudResource resource;
    private CrudPermission permission;
    private Boolean alwaysUseNative;

    public CrudHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public CrudHandlerImpl setResource(CrudResource resource) {
        this.resource = resource;
        return this;
    }

    public CrudHandlerImpl setPermission(CrudPermission permission) {
        this.permission = permission;
        return this;
    }

    public CrudHandlerImpl setAlwaysUseNative(Boolean alwaysUseNative) {
        this.alwaysUseNative = alwaysUseNative;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        if (this.alwaysUseNative == null) {
            this.alwaysUseNative = Boolean.FALSE;
        }
    }

    @Override
    public void onInitMapper() throws Exception {
        CrudHelper0.Mapper.initialize(this.entityTrxManager);
    }

    @Override
    public EntityTrxManager getEntityTrxManager() {
        return this.entityTrxManager;
    }

    @Override
    public CrudResource getCrudResource() {
        return this.resource;
    }

    @Override
    public CrudResult execute(CrudAction action, CrudRequest request) {
        boolean allowed;
        if (this.permission != null && !(allowed = this.permission.isCrudAllowed(action, request))) {
            return CrudConstant.Error.NOT_ALLOWED;
        }
        if (Boolean.TRUE.equals(this.alwaysUseNative)) {
            request.setUseNative(Boolean.TRUE);
        }
        return action.getExecutor().execute(request);
    }

    @Override
    public CrudRequest getRequest(byte[] data) {
        return CrudHelper1.getRequest(this, data);
    }

    @Override
    public CrudRequest getRequest() {
        return CrudHelper1.getRequest(this);
    }
}

